# Payroll

- [Payroll](#payroll)
  - [Payroll Items](#payroll-items)
  - [Add Payroll Item](#add-payroll-item)
  - [Payroll Templates](#payroll-templates)
  - [Add Payroll Template](#add-payroll-template)
  - [View Payroll](#view-payroll)
  - [Add Payroll](#add-payroll)

<a name="payroll"></a>
## Payroll

This module allows you to run a payroll for your employees.

<a name="payroll-items"></a>
## Payroll Items

Payroll items are the ones you will pick from when building your payslip. They can either be deduction or addition. To view a list of all your payroll items, click Payroll menu then click Manage Payroll Items.

<a name="add-payroll-item"></a>
### Add Payroll Item

To add new payroll item , click on Payroll menu then click Manage Payroll Items then click Add Item.
This will open the item create page offering a series of text  inputs.
The form contains:
- **Name:** The name of the item
- **Type:** Whether the item is an allowance or deduction
- **Amount Type:** Whether the amount is fixed or a percentage of the total amount
- **Amount:** The amount of the item
- **Description:** Any additional details

<a name="payroll-templates"></a>
## Payroll Templates

You can configure a template to be used when creating a payslip. To view a list of all your payroll templates, click Payroll menu then click Manage Payroll Templates.

<a name="add-payroll-template"></a>
### Add Payroll Template

To add new payroll template , click on Payroll menu then click Manage Payroll Templates then click Add Template.
This will open the template create page offering a series of text  inputs.
The form contains:
- **Name:** The name of the template
- **Work Duration:** The total number of days or hours
- **Duration Unit:** The unit of the duration, e.g. days or hours
- **Amount Per Duration:** The amount per duration. This will be multiplied by the work duration
- **Items:** The items applicable to the template.
- **Description:** Any additional details

<a name="view-payroll"></a>
## View Payroll

Clicking View Payroll will open income list page. On this page you will see a table with columns below:
- **ID:** The system id of the payroll
- **User:** The user of the payroll
- **Date:** The date the payroll was recorded
- **Amount:** The  amount of the payroll
- **Payment Status:**  Whether the payroll amount has been paid or not.
- **Action:** Further actions that you can take on the row like edit or details

<a name="add-payroll"></a>
## Add Payroll

To add new payroll , click on Payroll menu then click  Create Payroll.
This will open the payroll create page offering a series of text  inputs.
The form contains:

- **Branch:** The branch of the payroll
- **User:** The user of the payroll
- **Date:** The date the payroll was recorded
- **Template:** The payroll template 
- **Currency:** The payroll currency
- **Work Duration:** The total number of days or hours
- **Duration Unit:** The unit of the duration, e.g. days or hours
- **Amount Per Duration:** The amount per duration. This will be multiplied by the work duration
- **Total duration amount:** The total duration amount of the payroll
- **Allowances:** The payroll allowance items which will be loaded from the selected template. You can add additional items by clicking + icon
- **Deductions:** The payroll deductions items which will be loaded from the selected template. You can add additional items by clicking + icon
- **Bank Name:** The bank name where the money will be deposited
- **Recurring:**  Whether the payroll is recurring or not
- **Recur Frequency:** The frequency at which the payroll recurs for the recurring type.
- **Recur Type:** The period of time which the recur frequency occurs.
- **Recur Start Date:** The date to which the recurring starts.
- **Recur End Date:** The date to which the recurring should stop.
- **Description:**  Any additional details.

<a name="payroll-details"></a>
## Payroll Details

This page shows details about the payroll. You can add payroll payments here