<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('loan::general.repayment',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?php echo e(trans_choice('loan::general.collection_sheet',1)); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('report')); ?>"><?php echo e(trans_choice('report::general.report',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('report/loan')); ?>"><?php echo e(trans_choice('loan::general.loan',1)); ?> <?php echo e(trans_choice('report::general.report',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('loan::general.collection_sheet',1)); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="card ">
            <div class="card-header">
                <h6 class="card-title">
                    <?php echo e(trans_choice('loan::general.repayment',2)); ?>

                    <?php if(!empty($start_date)): ?>
                        for period: <b><?php echo e($start_date); ?> to <?php echo e($end_date); ?></b>
                    <?php endif; ?>
                </h6>

                <div class="card-tools hidden-print">
                    <div class="dropdown">
                        <a href="#" class="btn btn-info btn-trigger btn-icon dropdown-toggle"
                           data-toggle="dropdown">
                            <?php echo e(trans_choice('core::general.action',2)); ?>

                        </a>
                        <div class="dropdown-menu dropdown-menu-xs dropdown-menu-right">
                            <a href="<?php echo e(url('report/loan/repayment?download=1&type=csv&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id)); ?>" class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.csv_format',1)); ?></a>
                            <a href="<?php echo e(url('report/loan/repayment?download=1&type=excel&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id)); ?>" class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.excel_format',1)); ?></a>
                            <a href="<?php echo e(url('report/loan/repayment?download=1&type=excel_2007&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id)); ?>" class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.excel_2007_format',1)); ?></a>
                            <a href="<?php echo e(url('report/loan/repayment?download=1&type=pdf&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id)); ?>" class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.pdf_format',1)); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <form method="get" action="<?php echo e(Request::url()); ?>" class="">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"
                                       for="branch_id"><?php echo e(trans_choice('core::general.branch',1)); ?></label>
                                <select class="form-control select2" name="branch_id" id="branch_id" required>
                                    <option value="" disabled
                                            selected><?php echo e(trans_choice('core::general.select',1)); ?></option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key->id); ?>"
                                                <?php if($branch_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"
                                       for="start_date"><?php echo e(trans_choice('core::general.start_date',1)); ?></label>
                                <flat-pickr value="<?php echo e($start_date); ?>"
                                            class="form-control  <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="start_date" id="start_date" required>
                                </flat-pickr>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"
                                       for="end_date"><?php echo e(trans_choice('core::general.end_date',1)); ?></label>
                                <flat-pickr value="<?php echo e($end_date); ?>"
                                            class="form-control  <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="end_date" id="end_date" required>
                                </flat-pickr>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-2">
                        <span class="input-group-btn">
                          <button type="submit" class="btn bg-olive btn-flat"><?php echo e(trans_choice('core::general.filter',1)); ?>

                          </button>
                        </span>
                            <span class="input-group-btn">
                          <a href="<?php echo e(Request::url()); ?>"
                             class="btn bg-purple  btn-flat pull-right"><?php echo e(trans_choice('general.reset',1)); ?>!</a>
                        </span>
                        </div>
                    </div>
                </form>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.box -->
        <?php if(!empty($start_date)): ?>
            <div class="card">
                <div class="card-body table-responsive p-0">


                    <table class="table table-bordered table-condensed table-hover">
                        <thead>
                        <tr>
                            <th colspan="2">
                                <?php if(!empty($data->first()) && !empty($branch_id)): ?>
                                    <?php echo e(trans_choice('core::general.branch',1)); ?>:

                                    <?php echo e($data->first()->branch); ?>

                                <?php endif; ?>
                            </th>
                            <th colspan="2">
                                <?php if(!empty($data->first()) && !empty($loan_product_id)): ?>
                                    <?php echo e(trans_choice('loan::general.product',1)); ?>:

                                    <?php echo e($data->first()->loan_product); ?>

                                <?php endif; ?>
                            </th>
                            <th colspan="2">
                                <?php if(!empty($data->first()) && !empty($loan_officer_id)): ?>
                                    <?php echo e(trans_choice('loan::general.officer',1)); ?>:

                                    <?php echo e($data->first()->loan_officer); ?>

                                <?php endif; ?>
                            </th>
                            <th colspan="2"><?php echo e(trans_choice('core::general.start_date',1)); ?>: <?php echo e($start_date); ?></th>
                            <th colspan="3"><?php echo e(trans_choice('core::general.end_date',1)); ?>: <?php echo e($end_date); ?></th>
                        </tr>
                        <tr style="background-color: #D1F9FF">
                            <th><?php echo e(trans_choice('core::general.id',1)); ?></th>
                            <th><?php echo e(trans_choice('client::general.client',1)); ?></th>
                            <th><?php echo e(trans_choice('loan::general.loan',1)); ?>#</th>
                            <th><?php echo e(trans_choice('loan::general.loan',1)); ?> <?php echo e(trans_choice('loan::general.officer',1)); ?></th>
                            <th><?php echo e(trans_choice('loan::general.principal',1)); ?></th>
                            <th><?php echo e(trans_choice('loan::general.interest',1)); ?></th>
                            <th><?php echo e(trans_choice('loan::general.fee',2)); ?></th>
                            <th><?php echo e(trans_choice('loan::general.penalty',2)); ?></th>
                            <th><?php echo e(trans_choice('loan::general.total',1)); ?></th>
                            <th><?php echo e(trans_choice('core::general.date',1)); ?></th>
                            <th><?php echo e(trans_choice('core::general.payment',1)); ?> <?php echo e(trans_choice('core::general.type',1)); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $total_principal = 0;
                        $total_interest = 0;
                        $total_fees = 0;
                        $total_penalties = 0;
                        $total_amount = 0;
                        ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $total_principal = $total_principal + $key->principal_repaid_derived;
                            $total_interest = $total_interest + $key->interest_repaid_derived;
                            $total_fees = $total_fees + $key->fees_repaid_derived;
                            $total_penalties = $total_penalties + $key->penalties_repaid_derived;
                            ?>
                            <tr>
                                <td><?php echo e($key->id); ?></td>
                                <td>
                                    <?php echo e($key->client); ?>

                                </td>
                                <td><?php echo e($key->loan_id); ?></td>
                                <td><?php echo e($key->loan_officer); ?></td>
                                <td><?php echo e(number_format( $key->principal_repaid_derived,2)); ?></td>
                                <td><?php echo e(number_format( $key->interest_repaid_derived,2)); ?></td>
                                <td><?php echo e(number_format( $key->fees_repaid_derived,2)); ?></td>
                                <td><?php echo e(number_format( $key->penalties_repaid_derived,2)); ?></td>
                                <td><?php echo e(number_format( $key->principal_repaid_derived+$key->interest_repaid_derived+$key->fees_repaid_derived+$key->penalties_repaid_derived,2)); ?></td>
                                <td><?php echo e($key->submitted_on); ?></td>
                                <td><?php echo e($key->payment_type); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="4"><b><?php echo e(trans_choice('core::general.total',1)); ?></b></td>
                            <td><?php echo e(number_format($total_principal,2)); ?></td>
                            <td><?php echo e(number_format($total_interest,2)); ?></td>
                            <td><?php echo e(number_format($total_fees,2)); ?></td>
                            <td><?php echo e(number_format($total_penalties,2)); ?></td>
                            <td><?php echo e(number_format($total_principal+$total_interest+$total_fees+$total_penalties,2)); ?></td>
                            <td colspan="2"></td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        var app = new Vue({
            el: "#app",
            data: {},
            methods: {},
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Loan/Providers/../Resources/views/themes/adminlte/report/repayment.blade.php ENDPATH**/ ?>