<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('payroll::general.payroll',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?php echo e(trans_choice('payroll::general.payroll',2)); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('payroll::general.payroll',2)); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="card">
            <div class="card-header">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payroll.payroll.items.create')): ?>
                    <a href="<?php echo e(url('payroll/create')); ?>" class="btn btn-info btn-sm">
                        <i class="fas fa-plus"></i> <?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('payroll::general.payroll',1)); ?>

                    </a>
                <?php endif; ?>
                <div class="btn-group">
                    <div class="dropdown">
                        <a href="#" class="btn btn-trigger btn-icon dropdown-toggle"
                           data-toggle="dropdown">
                            <i class="fas fa-wrench"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-xs">
                            <a class="dropdown-item"><span>Show</span></a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['per_page'=>10])); ?>"
                               class="dropdown-item <?php echo e(request('per_page')==10?'active':''); ?>">
                                10
                            </a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['per_page'=>20])); ?>"
                               class="dropdown-item <?php echo e((request('per_page')==20||!request('per_page'))?'active':''); ?>">
                                20
                            </a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['per_page'=>50])); ?>"
                               class="dropdown-item <?php echo e(request('per_page')==50?'active':''); ?>">50</a>
                            <a class="dropdown-item">Order</a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['order_by_dir'=>'asc'])); ?>"
                               class="dropdown-item <?php echo e((request('order_by_dir')=='asc'||!request('order_by_dir'))?'active':''); ?>">
                                ASC
                            </a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['order_by_dir'=>'desc'])); ?>"
                               class="dropdown-item <?php echo e(request('order_by_dir')=='desc'?'active':''); ?>">
                                DESC
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-tools">
                    <form class="form-inline ml-0 ml-md-3" action="<?php echo e(url('payroll')); ?>">
                        <div class="input-group input-group-sm">
                            <input type="text" name="s" class="form-control" value="<?php echo e(request('s')); ?>"
                                   placeholder="Search">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table  table-striped table-hover table-condensed" id="data-table">
                    <thead>
                    <tr>
                        <th>
                            <a href="<?php echo e(table_order_link('id')); ?>">
                                <?php echo e(trans_choice('core::general.id',1)); ?>

                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(table_order_link('user')); ?>">
                                <?php echo e(trans_choice('core::general.user',1)); ?>

                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(table_order_link('date')); ?>">
                                <?php echo e(trans_choice('core::general.date',1)); ?>

                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(table_order_link('gross_amount')); ?>">
                                <?php echo e(trans_choice('payroll::general.amount',1)); ?>

                            </a>
                        </th>
                        <th><?php echo e(trans_choice('payroll::general.payment',1)); ?> <?php echo e(trans_choice('payroll::general.status',1)); ?></th>
                        <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <a href="<?php echo e(url('payroll/' . $key->id . '/show')); ?>">
                                    <span><?php echo e($key->id); ?></span>
                                </a>
                            </td>
                            <td>
                                <a href="<?php echo e(url('user/' . $key->user_id . '/show')); ?>">
                                    <span><?php echo e($key->user); ?></span>
                                </a>
                            </td>
                            <td>
                                <span><?php echo e($key->date); ?></span>
                            </td>
                            <td>
                                <span><?php echo e(number_format($key->gross_amount,2)); ?></span>
                            </td>
                            <td>
                                <?php if($key->payments >= $key->gross_amount): ?>
                                    <span class="badge badge-success"><?php echo e(trans_choice('payroll::general.paid', 1)); ?></span>
                                <?php elseif($key->payments < $key->gross_amount && $key->payments > 0): ?>
                                    <span class="badge badge-warning"><?php echo e(trans_choice('payroll::general.partially_paid', 1)); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-danger"><?php echo e(trans_choice('payroll::general.unpaid', 1)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button href="#" class="btn btn-default dropdown-toggle"
                                            data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-h"></i>
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        <a href="<?php echo e(url('payroll/' . $key->id . '/show')); ?>" class="dropdown-item">
                                            <i class="far fa-eye"></i>
                                            <span><?php echo e(trans_choice('core::general.detail',2)); ?></span>
                                        </a>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payroll.payroll.edit')): ?>
                                            <a href="<?php echo e(url('payroll/' . $key->id . '/edit')); ?>" class="dropdown-item">
                                                <i class="far fa-edit"></i>
                                                <span><?php echo e(trans_choice('core::general.edit',1)); ?></span>
                                            </a>
                                        <?php endif; ?>
                                        <div class="divider"></div>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payroll.payroll.destroy')): ?>
                                            <a href="<?php echo e(url('payroll/' . $key->id . '/destroy')); ?>"
                                               class="dropdown-item confirm">
                                                <i class="fas fa-trash"></i>
                                                <span><?php echo e(trans_choice('core::general.delete',1)); ?></span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-4">
                        <div><?php echo e(trans_choice('core::general.page',1)); ?> <?php echo e($data->currentPage()); ?> <?php echo e(trans_choice('core::general.of',1)); ?> <?php echo e($data->lastPage()); ?></div>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex justify-content-center">
                            <?php echo e($data->links()); ?>

                        </div>
                    </div>
                    <div class="col-md-4">

                    </div>
                </div>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        var app = new Vue({
            el: "#app",
            data: {
                records:<?php echo json_encode($data); ?>,
                selectAll: false,
                selectedRecords: []
            },
            methods: {
                selectAllRecords() {
                    this.selectedRecords = [];
                    if (this.selectAll) {
                        this.records.data.forEach(item => {
                            this.selectedRecords.push(item.id);
                        });
                    }
                },
            },
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Payroll/Providers/../Resources/views/themes/adminlte/payroll/index.blade.php ENDPATH**/ ?>