<?php $__env->startSection('title'); ?>
    <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>

                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('user')); ?>"><?php echo e(trans_choice('user::general.user',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body p-0">
                        <table class="table table-responsive table-hover">
                            <tr>
                                <td><?php echo e(trans('general.gender')); ?></td>
                                <td>
                                    <?php if($user->gender=='male'): ?>
                                        <?php echo e(trans('core::general.male')); ?>

                                    <?php endif; ?>
                                    <?php if($user->gender=='female'): ?>
                                        <?php echo e(trans('core::general.female')); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.email',1)); ?></td>
                                <td><?php echo e($user->email); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans('general.phone')); ?></td>
                                <td><?php echo e($user->phone); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans('general.address')); ?></td>
                                <td><?php echo $user->address; ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans('general.created_at')); ?></td>
                                <td><?php echo e($user->created_at); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans('general.updated_at')); ?></td>
                                <td><?php echo e($user->updated_at); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header with-border">
                        <h3 class="card-title"><?php echo e(trans_choice('general.note',2)); ?></h3>
                    </div>
                    <div class="card-body">
                        <?php echo $user->notes; ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $('.data-table').DataTable({
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                },
                "columnDefs": [
                    {"orderable": false, "targets": 0}
                ]
            },
            responsive: true,
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/User/Providers/../Resources/views/themes/adminlte/user/show.blade.php ENDPATH**/ ?>