<?php $__env->startSection('title'); ?>
    <?php echo e($client->first_name); ?> <?php echo e($client->last_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e($client->first_name); ?> <?php echo e($client->last_name); ?>

                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('client')); ?>"><?php echo e(trans_choice('client::general.client',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e($client->first_name); ?> <?php echo e($client->last_name); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="row">
            <div class="col-md-3">
                <div class="card card-bordered card-preview">
                    <div class="card-body box-profile">

                        <div class="text-center">
                            <?php if(!empty($client->photo)): ?>
                                <a href="<?php echo e(asset('storage/uploads/clients/'.$client->photo)); ?>"
                                   class="fancybox">
                                    <img
                                            class="profile-user-img img-fluid img-circle"
                                            src="<?php echo e(asset('storage/uploads/clients/'.$client->photo)); ?>"
                                            alt="User profile picture">
                                </a>
                            <?php else: ?>
                                <img class="profile-user-img img-fluid img-circle"
                                     src="<?php echo e(asset('themes/adminlte/img/user.png')); ?>"
                                     alt="User profile picture">
                            <?php endif; ?>
                        </div>
                        <h3 class="profile-username text-center">
                            <?php if(!empty($client->title)): ?>
                                <?php echo e($client->title->name); ?>

                            <?php endif; ?>
                            <?php echo e($client->name); ?>

                        </h3>
                        <?php if(!empty($client->profession->name)): ?>
                            <p class="text-muted text-center"><?php echo e($client->profession->name); ?></p>
                        <?php endif; ?>
                        <p class="text-muted text-center">#<?php echo e($client->id); ?></p>
                        <ul class="list-group list-group-unbordered mb-3">
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.branch',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php if(!empty($client->branch)): ?>
                                        <?php echo e($client->branch->name); ?>

                                    <?php endif; ?>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.status',1)); ?>

                                </b>
                                <a class="float-right">
                                    <a class="float-right" data-toggle="modal"
                                       data-target="#change_status_modal" href="#">
                                        <?php if($client->status=='pending'): ?>
                                            <?php echo e(trans_choice('core::general.pending',1)); ?>

                                        <?php endif; ?>
                                        <?php if($client->status=='active'): ?>
                                            <?php echo e(trans_choice('core::general.active',1)); ?>

                                        <?php endif; ?>
                                        <?php if($client->status=='inactive'): ?>
                                            <?php echo e(trans_choice('core::general.inactive',1)); ?>

                                        <?php endif; ?>
                                        <?php if($client->status=='deceased'): ?>
                                            <?php echo e(trans_choice('core::general.deceased',1)); ?>

                                        <?php endif; ?>
                                        <?php if($client->status=='other'): ?>
                                            <?php echo e(trans_choice('core::general.other',1)); ?>

                                        <?php endif; ?>
                                        <?php if($client->status=='closed'): ?>
                                            <?php echo e(trans_choice('core::general.closed',1)); ?>

                                        <?php endif; ?>
                                    </a>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.external_id',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php echo e($client->external_id); ?>

                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.type',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php if(!empty($client->client_type)): ?>
                                        <?php echo e($client->client_type->name); ?>

                                    <?php endif; ?>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.staff',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php if(!empty($client->loan_officer)): ?>
                                        <?php echo e($client->loan_officer->first_name); ?> <?php echo e($client->loan_officer->last_name); ?>

                                    <?php endif; ?>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.mobile',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php echo e($client->mobile); ?>

                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.email',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php echo e($client->email); ?>

                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.dob',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php echo e($client->dob); ?>

                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.gender',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php if($client->gender=='male'): ?>
                                        <?php echo e(trans_choice('core::general.male',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->gender=='female'): ?>
                                        <?php echo e(trans_choice('core::general.female',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->gender=='unspecified'): ?>
                                        <?php echo e(trans_choice('core::general.unspecified',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->gender=='other'): ?>
                                        <?php echo e(trans_choice('core::general.other',1)); ?>

                                    <?php endif; ?>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('client::general.marital_status',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php if($client->marital_status=='single'): ?>
                                        <?php echo e(trans_choice('client::general.single',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->marital_status=='married'): ?>
                                        <?php echo e(trans_choice('client::general.married',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->marital_status=='divorced'): ?>
                                        <?php echo e(trans_choice('client::general.divorced',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->marital_status=='widowed'): ?>
                                        <?php echo e(trans_choice('client::general.widowed',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->marital_status=='other'): ?>
                                        <?php echo e(trans_choice('client::general.other',1)); ?>

                                    <?php endif; ?>
                                    <?php if($client->marital_status=='unspecified'): ?>
                                        <?php echo e(trans_choice('core::general.unspecified',1)); ?>

                                    <?php endif; ?>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.zip',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php echo e($client->zip); ?>

                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.joined_date',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php echo e($client->created_date); ?>

                                </a>
                            </li>
                            <?php $__currentLoopData = $custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom_field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $field = custom_field_build_form_field($custom_field, $client->id);
                                ?>
                                <li class="list-group-item">
                                    <b>
                                        <?php echo e($field['label']); ?>

                                    </b>
                                    <a class="float-right">
                                        <?php if($custom_field->type=='checkbox'): ?>
                                            <?php $__currentLoopData = explode(',',$field['current'] ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($key); ?><br>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <?php echo e($field['current']); ?>

                                        <?php endif; ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item">
                                <b>
                                    <?php echo e(trans_choice('core::general.activation_date',1)); ?>

                                </b>
                                <a class="float-right">
                                    <?php echo e($client->activation_date); ?>

                                </a>
                            </li>
                        </ul>
                        <div class="d-flex justify-content-center">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.activate')): ?>
                                <a href="#" data-toggle="modal" class="btn btn-primary btn-sm  m-1"
                                   data-target="#change_status_modal">
                                    <i class="fas fa-check-circle"></i>
                                    <span><?php echo e(trans_choice('client::general.change',1)); ?> <?php echo e(trans_choice('core::general.status',1)); ?></span>
                                </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.edit')): ?>
                                <a href="<?php echo e(url('client/' . $client->id . '/edit')); ?>"
                                   class="btn btn-primary btn-sm  m-1">
                                    <i class="fas fa-edit"></i>
                                    <span><?php echo e(trans_choice('core::general.edit',1)); ?></span>
                                </a>

                                <a href="#" data-toggle="modal"
                                   data-target="#transfer_client_modal" class="btn btn-primary btn-sm m-1"><i
                                            class="fas fa-forward"></i>
                                    <span><?php echo e(trans_choice('client::general.transfer',1)); ?></span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <!-- /.card-header -->
                    <div class="card-body">

                        <strong><i class="fas fa-map-marker-alt mr-1"></i> <?php echo e(trans_choice('core::general.address',1)); ?>

                        </strong>

                        <p class="text-muted">
                            <?php echo e($client->address); ?><br>
                            <?php if(!empty($client->country)): ?>
                                <?php echo e($client->country->name); ?>

                            <?php endif; ?>
                        </p>

                        <hr>

                        <strong><i class="far fa-file-alt mr-1"></i> <?php echo e(trans_choice('core::general.note',2)); ?></strong>

                        <p class="text-muted"> <?php echo e($client->notes); ?></p>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
            <!-- /.col -->
            <div class="col-md-9">
                <div class="card card-primary card-outline card-outline-tabs">
                    <div class="card-header p-0 border-bottom-0">
                        <ul class="nav nav-tabs">
                            <li class="nav-item">
                                <a class="nav-link active" href="#accounts" data-toggle="tab"
                                   aria-expanded="false"><?php echo e(trans_choice('client::general.account',2)); ?>

                                </a>
                            </li>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.identification.index')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="#client_identification" data-toggle="tab"
                                       aria-expanded="false"><?php echo e(trans_choice('client::general.identification',1)); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.next_of_kin.index')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="#client_next_of_kin" data-toggle="tab"
                                       aria-expanded="true"><?php echo e(trans_choice('client::general.next_of_kin',1)); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.index')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="#login_details" data-toggle="tab"
                                       aria-expanded="false"><?php echo e(trans_choice('user::general.login',1)); ?> <?php echo e(trans_choice('core::general.detail',2)); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.files.index')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="#files" data-toggle="tab"
                                       aria-expanded="false"><?php echo e(trans_choice('client::general.file',2)); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="accounts">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('loan.loans.index')): ?>
                                    <h4><?php echo e(trans_choice('loan::general.loan',2)); ?></h4>
                                    <table class="table  table-striped table-hover table-condensed"
                                           id="loan-data-table">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('core::general.id',1)); ?></th>
                                            <th><?php echo e(trans_choice('core::general.amount',1)); ?></th>
                                            <th><?php echo e(trans_choice('loan::general.balance',1)); ?></th>
                                            <th><?php echo e(trans('loan::general.disbursed')); ?></th>
                                            <th><?php echo e(trans_choice('loan::general.status',1)); ?></th>
                                            <th><?php echo e(trans_choice('loan::general.product',1)); ?></th>
                                            <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.index')): ?>
                                    <h4><?php echo e(trans_choice('savings::general.savings',2)); ?></h4>
                                    <table class="table  table-striped table-hover table-condensed"
                                           id="savings-data-table">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('core::general.id',1)); ?></th>
                                            <th><?php echo e(trans_choice('savings::general.interest_rate',1)); ?></th>
                                            <th><?php echo e(trans_choice('savings::general.balance',1)); ?></th>
                                            <th><?php echo e(trans_choice('savings::general.status',1)); ?></th>
                                            <th><?php echo e(trans_choice('savings::general.product',1)); ?></th>
                                            <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                <?php endif; ?>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.identification.index')): ?>
                                <div class="tab-pane" id="client_identification">
                                    <div>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.identification.create')): ?>
                                            <a href="<?php echo e(url('client/'.$client->id.'/client_identification/create')); ?>"
                                               class="btn btn-info float-right mb-2"><?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('client::general.identification',1)); ?></a>
                                        <?php endif; ?>
                                        <table class="table table-striped table-bordered table-hover">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(trans_choice('core::general.type',1)); ?></th>
                                                <th><?php echo e(trans_choice('core::general.id',1)); ?></th>
                                                <th><?php echo e(trans_choice('core::general.description',1)); ?></th>
                                                <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $client->identifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <?php if(!empty($key->identification_type)): ?>
                                                            <?php echo e($key->identification_type->name); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($key->identification_value); ?></td>
                                                    <td><?php echo e($key->description); ?></td>
                                                    <td>
                                                        <a href="<?php echo e(asset('storage/uploads/clients/'.$key->link)); ?>"
                                                           target="_blank"><i class="fa fa-download"></i> </a>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.identification.edit')): ?>
                                                            <a href="<?php echo e(url('client/client_identification/'.$key->id.'/edit')); ?>"><i
                                                                        class="fas fa-edit"></i> </a>
                                                        <?php endif; ?>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.identification.destroy')): ?>
                                                            <a href="<?php echo e(url('client/client_identification/'.$key->id.'/destroy')); ?>"
                                                               class="confirm"><i class="fas fa-trash"></i> </a>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            <?php endif; ?>
                        <!-- /.tab-pane -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.next_of_kin.index')): ?>
                                <div class="tab-pane" id="client_next_of_kin">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.next_of_kin.create')): ?>
                                        <a href="<?php echo e(url('client/'.$client->id.'/client_next_of_kin/create')); ?>"
                                           class="btn btn-info float-right mb-2"><?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('client::general.next_of_kin',1)); ?></a>
                                    <?php endif; ?>
                                    <table class="table table-striped table-bordered table-hover">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('core::general.name',1)); ?></th>
                                            <th><?php echo e(trans('core::general.gender')); ?></th>
                                            <th><?php echo e(trans('core::general.dob')); ?></th>
                                            <th><?php echo e(trans('core::general.mobile')); ?></th>
                                            <th><?php echo e(trans_choice('core::general.email',1)); ?></th>
                                            <th><?php echo e(trans_choice('client::general.profession',1)); ?></th>
                                            <th><?php echo e(trans_choice('client::general.relationship',1)); ?></th>
                                            <th><?php echo e(trans_choice('core::general.address',1)); ?></th>
                                            <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $client->next_of_kins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></td>
                                                <td>
                                                    <?php if($key->gender=='male'): ?>
                                                        <?php echo e(trans_choice('core::general.male',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->gender=='female'): ?>
                                                        <?php echo e(trans_choice('core::general.female',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->gender=='unspecified'): ?>
                                                        <?php echo e(trans_choice('core::general.unspecified',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->gender=='other'): ?>
                                                        <?php echo e(trans_choice('core::general.other',1)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($key->dob); ?></td>
                                                <td><?php echo e($key->mobile); ?></td>
                                                <td><?php echo e($key->email); ?></td>
                                                <td>
                                                    <?php if(!empty($key->profession)): ?>
                                                        <?php echo e($key->profession->name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(!empty($key->client_relationship)): ?>
                                                        <?php echo e($key->client_relationship->name); ?>

                                                    <?php endif; ?>
                                                </td>

                                                <td><?php echo e($key->address); ?></td>
                                                <td>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.next_of_kin.edit')): ?>
                                                        <a href="<?php echo e(url('client/client_next_of_kin/'.$key->id.'/edit')); ?>"><i
                                                                    class="fas fa-edit"></i> </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.next_of_kin.destroy')): ?>
                                                        <a href="<?php echo e(url('client/client_next_of_kin/'.$key->id.'/destroy')); ?>"
                                                           class="confirm"><i class="fas fa-trash"></i> </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                            <div class="tab-pane" id="login_details">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.user.create')): ?>
                                    <a href="<?php echo e(url('client/'.$client->id.'/user/create')); ?>"
                                       class="btn btn-info float-right mb-2"><?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('core::general.user',1)); ?></a>
                                <?php endif; ?>
                                <table class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans_choice('core::general.name',1)); ?></th>
                                        <th><?php echo e(trans_choice('core::general.email',1)); ?></th>
                                        <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $client->client_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($key->user): ?>
                                            <tr>
                                                <td><?php echo e($key->user->first_name); ?> <?php echo e($key->user->last_name); ?></td>
                                                <td><?php echo e($key->user->email); ?></td>
                                                <td>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.user.create')): ?>
                                                        <a href="<?php echo e(url('user/'.$key->user_id.'/edit')); ?>"
                                                           class=""><i class="fas fa-edit"></i> </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.user.destroy')): ?>
                                                        <a href="<?php echo e(url('client/user/'.$key->id.'/destroy')); ?>"
                                                           class="confirm"><i class="fas fa-trash"></i> </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.files.index')): ?>
                                <div class="tab-pane" id="files">
                                    <div>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.files.index')): ?>
                                            <a href="<?php echo e(url('client/'.$client->id.'/file/create')); ?>"
                                               class="btn btn-info float-right mb-2"><?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('client::general.file',1)); ?></a>
                                        <?php endif; ?>
                                        <table class="table table-striped table-bordered table-hover">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(trans_choice('core::general.name',1)); ?></th>
                                                <th><?php echo e(trans_choice('core::general.description',1)); ?></th>
                                                <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $client->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($key->name); ?></td>
                                                    <td><?php echo e($key->description); ?></td>
                                                    <td>
                                                        <a href="<?php echo e(asset('storage/uploads/clients/'.$key->link)); ?>"
                                                           target="_blank"><i class="fa fa-download"></i> </a>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.files.edit')): ?>
                                                            <a href="<?php echo e(url('client/file/'.$key->id.'/edit')); ?>"><i
                                                                        class="fas fa-edit"></i> </a>
                                                        <?php endif; ?>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client.clients.files.destroy')): ?>
                                                            <a href="<?php echo e(url('client/file/'.$key->id.'/destroy')); ?>"
                                                               class="confirm"><i class="fas fa-trash"></i> </a>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            </div>
            <!-- /.col -->
        </div>
        <div class="modal fade in" id="change_status_modal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><?php echo e(trans_choice('client::general.change',1)); ?> <?php echo e(trans_choice('core::general.status',1)); ?></h4>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>×</span></button>
                    </div>
                    <form method="post"
                          action="<?php echo e(url('client/'.$client->id.'/change_status')); ?>"
                          class="form-horizontal">
                        <?php echo e(csrf_field()); ?>

                        <div class="modal-body">
                            <div class="form-group">
                                <label for="status"
                                       class="control-label"><?php echo e(trans_choice('core::general.status',1)); ?></label>
                                <select class="form-control" name="status" id="status">
                                    <option value=""></option>
                                    <option value="pending"
                                            <?php if($client->status=="pending"): ?> selected <?php endif; ?>><?php echo e(trans_choice("client::general.pending",1)); ?></option>
                                    <option value="active"
                                            <?php if($client->status=="active"): ?> selected <?php endif; ?>><?php echo e(trans_choice("client::general.active",1)); ?></option>
                                    <option value="inactive"
                                            <?php if($client->status=="inactive"): ?> selected <?php endif; ?>><?php echo e(trans_choice("client::general.inactive",1)); ?></option>
                                    <option value="closed"
                                            <?php if($client->status=="closed"): ?> selected <?php endif; ?>><?php echo e(trans_choice("client::general.closed",1)); ?></option>
                                    <option value="deceased"
                                            <?php if($client->status=="deceased"): ?> selected <?php endif; ?>><?php echo e(trans_choice("client::general.deceased",1)); ?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="status_date"
                                       class="control-label"><?php echo e(trans_choice('core::general.date',1)); ?></label>
                                <input type="text" name="date"
                                       class="form-control date-picker"
                                       value="<?php echo e(date("Y-m-d")); ?>"
                                       required=""
                                       id="status_date">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default float-left"
                                    data-dismiss="modal">
                                <?php echo e(trans_choice('core::general.close',1)); ?>

                            </button>
                            <button type="submit"
                                    class="btn btn-primary float-right"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

    <script>
        $(document).ready(function () {


            $('#savings-data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo url('savings/get_savings?client_id='.$client->id); ?>',
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'interest_rate', name: 'interest_rate'},
                    {data: 'balance', name: 'balance'},
                    {data: 'status', name: 'status'},
                    {data: 'savings_product', name: 'savings_products.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ],
                "order": [[0, "desc"]],
                "language": {
                    "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                    "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                    "info": "<?php echo e(trans('general.info')); ?>",
                    "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                    "search": "<?php echo e(trans('general.search')); ?>",
                    "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                    "paginate": {
                        "first": "<?php echo e(trans('general.first')); ?>",
                        "last": "<?php echo e(trans('general.last')); ?>",
                        "next": "<?php echo e(trans('general.next')); ?>",
                        "previous": "<?php echo e(trans('general.previous')); ?>"
                    }
                },
                responsive: false,
                "autoWidth": false,
                "drawCallback": function (settings) {
                    $('.confirm').on('click', function (e) {
                        e.preventDefault();
                        var href = $(this).attr('href');
                        swal({
                            title: 'Are you sure?',
                            text: '',
                            type: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Ok',
                            cancelButtonText: 'Cancel'
                        }).then(function () {
                            window.location = href;
                        })
                    });
                }
            });
            $('#loan-data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo url('loan/get_loans?client_id='.$client->id); ?>',
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'principal', name: 'principal'},
                    {data: 'balance', name: 'balance', orderable: false},
                    {data: 'disbursed_on_date', name: 'disbursed_on_date'},
                    {data: 'status', name: 'status'},
                    {data: 'loan_product', name: 'loan_products.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ],
                "order": [[0, "desc"]],
                "language": {
                    "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                    "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                    "info": "<?php echo e(trans('general.info')); ?>",
                    "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                    "search": "<?php echo e(trans('general.search')); ?>",
                    "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                    "paginate": {
                        "first": "<?php echo e(trans('general.first')); ?>",
                        "last": "<?php echo e(trans('general.last')); ?>",
                        "next": "<?php echo e(trans('general.next')); ?>",
                        "previous": "<?php echo e(trans('general.previous')); ?>"
                    }
                },
                responsive: false,
                "drawCallback": function (settings) {
                    $('.confirm').on('click', function (e) {
                        e.preventDefault();
                        var href = $(this).attr('href');
                        swal({
                            title: 'Are you sure?',
                            text: '',
                            type: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Ok',
                            cancelButtonText: 'Cancel'
                        }).then(function () {
                            window.location = href;
                        })
                    });
                }
            });
        })
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Client/Providers/../Resources/views/themes/adminlte/client/show.blade.php ENDPATH**/ ?>