<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('payroll::general.payroll',1)); ?> #<?php echo e($payroll->id); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e(trans_choice('payroll::general.payroll',1)); ?> #<?php echo e($payroll->id); ?>

                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('payroll')); ?>"><?php echo e(trans_choice('payroll::general.payroll',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('payroll::general.payroll',1)); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-header with-border">
                        <h3 class="card-title"><?php echo e(trans_choice('payroll::general.payroll',1)); ?> #<?php echo e($payroll->id); ?></h3>
                    </div>

                    <div class="card-body">
                        <table class="table">
                            <tr>
                                <td><?php echo e(trans_choice('user::general.user',1)); ?> </td>
                                <td>
                                    <?php echo e($payroll->employee_name); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('core::general.date',1)); ?> </td>
                                <td>
                                    <?php echo e($payroll->date); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('payroll::general.template',1)); ?> </td>
                                <td>
                                    <?php if(!empty($payroll->payroll_template)): ?>
                                        <?php echo e($payroll->payroll_template->name); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('payroll::general.work_duration',1)); ?> </td>
                                <td>
                                    <?php echo e(number_format($payroll->work_duration,2)); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('payroll::general.duration_unit',1)); ?> </td>
                                <td>
                                    <?php echo e($payroll->duration_unit); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('payroll::general.amount_per_duration',1)); ?> </td>
                                <td>
                                    <?php echo e(number_format($payroll->amount_per_duration,2)); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('payroll::general.total_duration_amount',1)); ?> </td>
                                <td>
                                    <?php echo e(number_format($payroll->total_duration_amount,2)); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('payroll::general.gross',1)); ?> <?php echo e(trans_choice('payroll::general.amount',1)); ?></td>
                                <td>
                                    <b><?php echo e(number_format($payroll->gross_amount,2)); ?></b>
                                </td>
                            </tr>
                            <tr>
                                <td> <?php echo e(trans_choice('payroll::general.payment',2)); ?></td>
                                <td>
                                    <b><?php echo e(number_format($payments,2)); ?></b>
                                </td>
                            </tr>
                            <tr>
                                <td> <?php echo e(trans_choice('payroll::general.balance',1)); ?></td>
                                <td>
                                    <b><?php echo e(number_format($payroll->gross_amount-$payments,2)); ?></b>
                                </td>
                            </tr>
                        </table>

                    </div>

                </div>
            </div>
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo e(trans_choice('payroll::general.item',2)); ?></h6>

                        <div class="card-tools">
                            <a href="<?php echo e(url('payroll/'.$payroll->id.'/pdf')); ?>" target="_blank"
                               class="btn btn-info btn-sm">
                                <i class="fas fa-file-pdf"></i> <?php echo e(trans_choice('core::general.pdf',1)); ?>

                            </a>
                            <a href="<?php echo e(url('payroll/'.$payroll->id.'/print')); ?>" target="_blank"
                               class="btn btn-info btn-sm">
                                <i class="fas fa-print"></i> <?php echo e(trans_choice('core::general.print',1)); ?>

                            </a>
                        </div>
                    </div>

                    <div class="card-body">
                        <h4><?php echo e(trans_choice('payroll::general.allowance',2)); ?></h4>
                        <table class="table table-striped table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(trans_choice('payroll::general.allowance',1)); ?></th>
                                <th><?php echo e(trans_choice('payroll::general.amount',1)); ?> <?php echo e(trans_choice('payroll::general.type',1)); ?></th>
                                <th><?php echo e(trans_choice('payroll::general.amount',1)); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $payroll->payroll_items->where('type','allowance')->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr v-for="(item,index) in selected_allowances">
                                    <td>
                                        <?php echo e($key->name); ?>

                                    </td>
                                    <td>
                                        <?php if($key->amount_type=='fixed'): ?>
                                            <?php echo e(trans_choice('payroll::general.fixed',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->amount_type=='percentage'): ?>
                                            <?php echo e(trans_choice('payroll::general.percentage',1)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(number_format($key->amount,2)); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                            <tr>
                                <th colspan="2"><?php echo e(trans_choice('payroll::general.total',1)); ?></th>
                                <th colspan="1"><?php echo e(number_format($payroll->total_allowances,2)); ?></th>
                            </tr>
                            </tfoot>
                        </table>
                        <h4><?php echo e(trans_choice('payroll::general.deduction',2)); ?></h4>
                        <table class="table table-striped table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(trans_choice('payroll::general.deduction',1)); ?></th>
                                <th><?php echo e(trans_choice('payroll::general.amount',1)); ?> <?php echo e(trans_choice('payroll::general.type',1)); ?></th>
                                <th><?php echo e(trans_choice('payroll::general.amount',1)); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $payroll->payroll_items->where('type','deduction')->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr v-for="(item,index) in selected_allowances">
                                    <td>
                                        <?php echo e($key->name); ?>

                                    </td>
                                    <td>
                                        <?php if($key->amount_type=='fixed'): ?>
                                            <?php echo e(trans_choice('payroll::general.fixed',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->amount_type=='percentage'): ?>
                                            <?php echo e(trans_choice('payroll::general.percentage',1)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(number_format($key->amount,2)); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                            <tr>
                                <th colspan="2"><?php echo e(trans_choice('payroll::general.total',1)); ?></th>
                                <th colspan="1"><?php echo e(number_format($payroll->total_deductions,2)); ?></th>
                            </tr>
                            </tfoot>
                        </table>
                        <h4><?php echo e(trans_choice('payroll::general.payment',2)); ?></h4>
                        <h4 class="float-right">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payroll.payroll.create')): ?>
                                <a href="<?php echo e(url('payroll/'.$payroll->id.'/payment/create')); ?>"
                                   class="btn btn-info btn-sm">
                                    <?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('core::general.payment',1)); ?>

                                </a>
                            <?php endif; ?>
                        </h4>
                        <div class="clearfix"></div>
                        <table class="table table-striped table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(trans_choice('core::general.id',1)); ?></th>
                                <th><?php echo e(trans_choice('core::general.payment',1)); ?> <?php echo e(trans_choice('payroll::general.type',1)); ?></th>
                                <th><?php echo e(trans_choice('payroll::general.amount',1)); ?></th>
                                <th><?php echo e(trans_choice('core::general.receipt',1)); ?></th>
                                <th><?php echo e(trans_choice('core::general.date',1)); ?></th>
                                <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $payroll->payroll_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php echo e($key->id); ?>

                                    </td>
                                    <td>
                                        <?php if(!empty($key->payment_detail)): ?>
                                            <?php if(!empty($key->payment_detail->payment_type)): ?>
                                                <?php echo e($key->payment_detail->payment_type->name); ?>

                                            <?php endif; ?>
                                        <?php endif; ?>

                                    </td>
                                    <td><?php echo e(number_format($key->amount,2)); ?></td>
                                    <td>
                                        <?php if(!empty($key->payment_detail)): ?>
                                            <?php echo e($key->payment_detail->receipt); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($key->submitted_on); ?>

                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button href="#" class="btn btn-default dropdown-toggle"
                                                    data-toggle="dropdown">
                                                <i class="fas fa-ellipsis-h"></i>
                                            </button>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payroll.payroll.edit')): ?>
                                                    <a href="<?php echo e(url('payroll/payment/' . $key->id . '/edit')); ?>"
                                                       class="dropdown-item">
                                                        <i class="far fa-edit"></i> <?php echo e(trans_choice('core::general.edit', 2)); ?>

                                                    </a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payroll.payroll.destroy')): ?>
                                                    <a href="<?php echo e(url('payroll/payment/' . $key->id . '/destroy')); ?>"
                                                       class="dropdown-item confirm">
                                                        <i class="fas fa-trash"></i> <?php echo e(trans_choice('core::general.delete', 2)); ?>

                                                    </a>

                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                            <tr>
                                <th colspan="2"><?php echo e(trans_choice('payroll::general.total',1)); ?></th>
                                <th colspan="1"><?php echo e(number_format($payments,2)); ?></th>
                                <th colspan="3"></th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Payroll/Providers/../Resources/views/themes/adminlte/payroll/show.blade.php ENDPATH**/ ?>