<?php $__env->startSection('title'); ?>
    <?php echo e(__('user::general.Notifications')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e(__('user::general.Notifications')); ?> / <strong
                                class="text-primary small"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></strong>
                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(__('user::general.Notifications')); ?> / <strong
                                    class="text-primary small"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></strong>
                        </li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="row">
            <div class="col-md-3">
                <?php echo $__env->make('user::themes.adminlte.user.profile.user_profile_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <!-- /.col -->
            <div class="col-md-9">
                <div class="card card-bordered card-preview">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e(__('user::general.Notifications')); ?></h4>
                        <div class="card-tools">
                            <a href="<?php echo e(url('admin/user/profile/notification/mark_all_as_read')); ?>"
                               class="btn  btn-success confirm">
                                <small><?php echo e(__('user::general.Mark All As Read')); ?></small>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="post  <?php if(!$notification->read_at): ?> bg-light <?php endif; ?>">
                               <p><?php echo e($notification->data['message']); ?></p>
                                <p>
                                    <small><?php echo e($notification->created_at->diffForHumans()); ?></small>
                                    <a class="link-black text-sm mr-2"
                                       href="<?php echo e(url('user/profile/notification/'.$notification->id.'/show')); ?>">
                                        <small><i
                                                class="fas fa-eye"></i>
                                        <?php echo e(trans_choice('core::general.detail',2)); ?>

                                        </small>
                                    </a>
                                    <?php if(!$notification->read_at): ?>
                                        <a href="<?php echo e(url('user/profile/notification/'.$notification->id.'/mark_as_read')); ?>"
                                           class="link-black text-sm mr-2">
                                            <small>
                                            <i class="icon ni ni-emails"></i>
                                            <?php echo e(__('user::general.Mark As Read')); ?>

                                            </small>
                                        </a>

                                    <?php endif; ?>
                                    <a class="link-black text-sm mr-2 confirm"
                                       href="<?php echo e(url('user/profile/notification/'.$notification->id.'/destroy')); ?>">
                                        <small><i
                                                class="fas fa-trash"></i>
                                            <?php echo e(trans_choice('core::general.delete',1)); ?>

                                        </small>
                                    </a>
                                </p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex">
                            <div class="mx-auto">
                                <?php echo e($data->links()); ?>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/User/Providers/../Resources/views/themes/adminlte/user/profile/notification.blade.php ENDPATH**/ ?>