<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('core::general.detail',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('core::general.detail',2)); ?>

                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('savings')); ?>"><?php echo e(trans_choice('savings::general.savings',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('core::general.detail',2)); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="row">
            <div class="col-md-12">
                <div class="card ">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($savings->savings_product->name); ?>(#<?php echo e($savings->id); ?>)</h5>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="float-right btn-group">
                                    <?php if($savings->status=='submitted' ||$savings->status=='pending'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.approve_savings')): ?>
                                            <a href="#" data-toggle="modal" data-target="#approve_savings_modal"
                                               class="btn btn-primary"><i
                                                        class="fas fa-check"></i>
                                                <?php echo e(trans_choice('savings::general.approve',1)); ?>

                                            </a>
                                            <a href="#" data-toggle="modal" data-target="#reject_savings_modal"
                                               class="btn btn-primary"><i class="fas fa-times"></i>
                                                <?php echo e(trans_choice('savings::general.reject',1)); ?>

                                            </a>
                                            <a href="#" data-toggle="modal" data-target="#withdraw_savings_modal"
                                               class="btn btn-primary"><i class="fas fa-times"></i>
                                                <?php echo e(trans_choice('savings::general.withdraw',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.edit')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/edit')); ?>"
                                               class="btn btn-primary">
                                                <i class="fas fa-edit"></i>
                                                <?php echo e(trans_choice('core::general.edit',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.approve_savings')): ?>
                                            <div class="modal fade" id="approve_savings_modal">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(trans_choice('savings::general.approve',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?></h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                <span aria-hidden="true">×</span></button>

                                                        </div>
                                                        <form method="post"
                                                              action="<?php echo e(url('savings/'.$savings->id.'/approve_savings')); ?>">
                                                            <?php echo e(csrf_field()); ?>

                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="approved_on_date"
                                                                           class="control-label"><?php echo e(trans_choice('core::general.date',1)); ?></label>
                                                                    <flat-pickr
                                                                            class="form-control  <?php $__errorArgs = ['approved_on_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                            name="approved_on_date"
                                                                            value="<?php echo e(date("Y-m-d")); ?>"
                                                                            id="approved_on_date" required>
                                                                    </flat-pickr>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="approved_notes"
                                                                           class="control-label"><?php echo e(trans_choice('core::general.note',2)); ?></label>
                                                                    <textarea name="approved_notes"
                                                                              class="form-control"
                                                                              id="approved_notes"
                                                                              rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                        class="btn btn-default pull-left"
                                                                        data-dismiss="modal">
                                                                    <?php echo e(trans_choice('core::general.close',1)); ?>

                                                                </button>
                                                                <button type="submit"
                                                                        class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal fade" id="reject_savings_modal">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(trans_choice('savings::general.reject',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?></h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                <span aria-hidden="true">×</span></button>

                                                        </div>
                                                        <form method="post"
                                                              action="<?php echo e(url('savings/'.$savings->id.'/reject_savings')); ?>">
                                                            <?php echo e(csrf_field()); ?>

                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="rejected_notes"
                                                                           class="control-label"><?php echo e(trans_choice('core::general.note',2)); ?></label>
                                                                    <textarea name="rejected_notes"
                                                                              class="form-control"
                                                                              id="rejected_notes"
                                                                              rows="3" required=""></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                        class="btn btn-default pull-left"
                                                                        data-dismiss="modal">
                                                                    <?php echo e(trans_choice('core::general.close',1)); ?>

                                                                </button>
                                                                <button type="submit"
                                                                        class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal fade" id="withdraw_savings_modal">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(trans_choice('savings::general.withdraw',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?></h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                <span aria-hidden="true">×</span></button>
                                                        </div>
                                                        <form method="post"
                                                              action="<?php echo e(url('savings/'.$savings->id.'/withdraw_savings')); ?>">
                                                            <?php echo e(csrf_field()); ?>

                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="withdrawn_notes"
                                                                           class="control-label"><?php echo e(trans_choice('core::general.note',2)); ?></label>
                                                                    <textarea name="withdrawn_notes"
                                                                              class="form-control"
                                                                              id="withdrawn_notes" rows="3"
                                                                              required=""></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                        class="btn btn-default pull-left"
                                                                        data-dismiss="modal">
                                                                    <?php echo e(trans_choice('core::general.close',1)); ?>

                                                                </button>
                                                                <button type="submit"
                                                                        class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($savings->status=='active'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.transactions.create')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/deposit/create')); ?>"
                                               class="btn btn-success"><i class="fas fa-dollar-sign"></i>
                                                <?php echo e(trans_choice('savings::general.make',1)); ?> <?php echo e(trans_choice('savings::general.deposit',1)); ?>

                                            </a>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/withdrawal/create')); ?>"
                                               class="btn btn-warning"><i class="fas fa-money-bill"></i>
                                                <?php echo e(trans_choice('savings::general.make',1)); ?> <?php echo e(trans_choice('savings::general.withdrawal',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.edit')): ?>
                                            <a href="#" data-toggle="modal"
                                               data-target="#change_savings_officer_modal"
                                               class="btn btn-primary">
                                                <?php echo e(trans_choice('savings::general.change',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('savings::general.officer',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.charges.create')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/charge/create')); ?>"
                                               class="btn btn-primary"><i
                                                        class="fa fa-plus"></i>
                                                <?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('savings::general.charge',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.close_savings')): ?>
                                            <a href="#" data-toggle="modal" data-target="#close_savings_modal"
                                               class="btn btn-primary">
                                                <?php echo e(trans_choice('core::general.close',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.activate_savings')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/undo_activation')); ?>"
                                               class="btn btn-danger confirm"><i class="fa fa-undo"></i>
                                                <?php echo e(trans_choice('savings::general.undo',1)); ?> <?php echo e(trans_choice('savings::general.activation',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.edit')): ?>
                                            <div class="modal fade" id="change_savings_officer_modal">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(trans_choice('savings::general.change',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('savings::general.officer',1)); ?></h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                <span aria-hidden="true">×</span></button>
                                                        </div>
                                                        <form method="post"
                                                              action="<?php echo e(url('savings/'.$savings->id.'/change_savings_officer')); ?>">
                                                            <?php echo e(csrf_field()); ?>

                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="savings_officer_id"
                                                                           class="control-label"><?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('savings::general.officer',1)); ?></label>
                                                                    <select class="form-control select2"
                                                                            name="savings_officer_id"
                                                                            id="savings_officer_id"
                                                                            v-model="savings_officer_id"
                                                                            required>
                                                                        <option value=""></option>
                                                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($key->id); ?>"
                                                                                    <?php if($key->id==$savings->savings_officer_id): ?> selected <?php endif; ?>><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                        class="btn btn-default pull-left"
                                                                        data-dismiss="modal">
                                                                    <?php echo e(trans_choice('core::general.close',1)); ?>

                                                                </button>
                                                                <button type="submit"
                                                                        class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.close_savings')): ?>
                                            <div class="modal fade" id="close_savings_modal">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(trans_choice('core::general.close',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?></h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                <span aria-hidden="true">×</span></button>
                                                        </div>
                                                        <form method="post"
                                                              action="<?php echo e(url('savings/'.$savings->id.'/close_savings')); ?>">
                                                            <?php echo e(csrf_field()); ?>

                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="closed_notes"
                                                                           class="control-label"><?php echo e(trans_choice('core::general.note',2)); ?></label>
                                                                    <textarea name="closed_notes"
                                                                              class="form-control"
                                                                              id="closed_notes"
                                                                              rows="3" required></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                        class="btn btn-default pull-left"
                                                                        data-dismiss="modal">
                                                                    <?php echo e(trans_choice('core::general.close',1)); ?>

                                                                </button>
                                                                <button type="submit"
                                                                        class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($savings->status=='closed'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.close_savings')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/undo_closed')); ?>"
                                               class="btn btn-primary confirm"><i class="fas fa-undo"></i>
                                                <?php echo e(trans_choice('savings::general.activate',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($savings->status=='inactive'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.inactive_savings')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/undo_inactive')); ?>"
                                               class="btn btn-primary confirm"><i class="fa fa-undo"></i>
                                                <?php echo e(trans_choice('savings::general.activate',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($savings->status=='dormant'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.dormant_savings')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/undo_dormant')); ?>"
                                               class="btn btn-primary confirm"><i class="fa fa-undo"></i>
                                                <?php echo e(trans_choice('savings::general.activate',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($savings->status=='approved'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.activate_savings')): ?>
                                            <a href="#" data-toggle="modal" data-target="#activate_savings_modal"
                                               class="btn btn-primary"><i class="fa fa-flag"></i>
                                                <?php echo e(trans_choice('savings::general.activate',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.edit')): ?>
                                            <a href="#" data-toggle="modal"
                                               data-target="#change_savings_officer_modal"
                                               class="btn btn-primary">
                                                <?php echo e(trans_choice('savings::general.change',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('savings::general.officer',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.approve_savings')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/undo_approval')); ?>"
                                               class="btn btn-primary confirm"><i class="fas fa-undo"></i>
                                                <?php echo e(trans_choice('savings::general.undo',1)); ?> <?php echo e(trans_choice('savings::general.approval',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.edit')): ?>
                                            <div class="modal fade" id="change_savings_officer_modal">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(trans_choice('savings::general.change',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('savings::general.officer',1)); ?></h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                <span aria-hidden="true">×</span></button>
                                                        </div>
                                                        <form method="post"
                                                              action="<?php echo e(url('savings/'.$savings->id.'/change_savings_officer')); ?>">
                                                            <?php echo e(csrf_field()); ?>

                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="savings_officer_id"
                                                                           class="control-label"><?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('savings::general.officer',1)); ?></label>
                                                                    <select class="form-control select2"
                                                                            name="savings_officer_id"
                                                                            id="savings_officer_id"
                                                                            v-model="savings_officer_id"
                                                                            required>
                                                                        <option value=""></option>
                                                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($key->id); ?>"
                                                                                    <?php if($key->id==$savings->savings_officer_id): ?> selected <?php endif; ?>><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                        class="btn btn-default pull-left"
                                                                        data-dismiss="modal">
                                                                    <?php echo e(trans_choice('core::general.close',1)); ?>

                                                                </button>
                                                                <button type="submit"
                                                                        class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.activate_savings')): ?>
                                            <div class="modal fade in" id="activate_savings_modal">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(trans_choice('savings::general.activate',1)); ?> <?php echo e(trans_choice('savings::general.savings',1)); ?></h4>
                                                            <button type="button" class="close" data-dismiss="modal">
                                                                <span>×</span></button>
                                                        </div>
                                                        <form method="post"
                                                              action="<?php echo e(url('savings/'.$savings->id.'/activate_savings')); ?>"
                                                              class="form-horizontal">
                                                            <?php echo e(csrf_field()); ?>

                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="activated_on_date"
                                                                           class="control-label"><?php echo e(trans_choice('savings::general.activation',1)); ?> <?php echo e(trans_choice('core::general.date',1)); ?></label>

                                                                    <flat-pickr
                                                                            class="form-control  <?php $__errorArgs = ['activated_on_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                            name="activated_on_date"
                                                                            value="<?php echo e(date("Y-m-d")); ?>"
                                                                            id="activated_on_date" required>
                                                                    </flat-pickr>

                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="activated_notes"
                                                                           class="control-label"><?php echo e(trans_choice('core::general.note',2)); ?></label>

                                                                    <textarea name="activated_notes"
                                                                              class="form-control"
                                                                              id="activated_notes"
                                                                              rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                        class="btn btn-default pull-left"
                                                                        data-dismiss="modal">
                                                                    <?php echo e(trans_choice('core::general.close',1)); ?>

                                                                </button>
                                                                <button type="submit"
                                                                        class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($savings->status=='rejected'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.approve_savings')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/undo_rejection')); ?>"
                                               class="btn btn-primary confirm"><i class="fas fa-undo"></i>
                                                <?php echo e(trans_choice('savings::general.undo',1)); ?> <?php echo e(trans_choice('savings::general.rejection',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($savings->status=='withdrawn'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.approve_savings')): ?>
                                            <a href="<?php echo e(url('savings/'.$savings->id.'/undo_withdrawn')); ?>"
                                               class="btn btn-primary confirm"><i class="fas fa-undo"></i>
                                                <?php echo e(trans_choice('savings::general.undo',1)); ?> <?php echo e(trans_choice('savings::general.withdrawn',1)); ?>

                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 20px">
                            <div class="col-sm-8 col-md-8 p-10">
                                <?php if($savings->status=='submitted' ||$savings->status=='pending'||$savings->status=='withdrawn'||$savings->status=='approved'||$savings->status=='rejected'): ?>
                                    <?php if($savings->status=='submitted'): ?>
                                        <span class="badge badge-warning badge-lg m-2 status-label"><?php echo e(trans_choice('savings::general.pending_approval',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($savings->status=='approved'): ?>
                                        <span class="badge badge-warning badge-lg m-2 status-label"><?php echo e(trans_choice('savings::general.awaiting_activation',1)); ?></span>
                                    <?php endif; ?>
                                    <?php if($savings->status=='withdrawn'): ?>
                                        <span class="badge badge-danger badge-lg m-2 status-label"><?php echo e(trans_choice('savings::general.withdrawn',1)); ?></span>

                                    <?php endif; ?>
                                    <?php if($savings->status=='rejected'): ?>
                                        <span class="badge badge-danger badge-lg m-2 status-label"><?php echo e(trans_choice('savings::general.rejected',1)); ?></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if($savings->status=='active' ||$savings->status=='closed'||$savings->status=='dormant'||$savings->status=='inactive'): ?>
                                    <table class="table table-striped table-bordered">
                                        <tbody>
                                        <tr>
                                            <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.current',1)); ?> <?php echo e(trans_choice('savings::general.balance',1)); ?></th>
                                            <td>
                                                <?php echo e(number_format($savings->transactions->where('reversed',0)->sum('credit')-$savings->transactions->where('reversed',0)->sum('debit'),$savings->decimals)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.interest',1)); ?> <?php echo e(trans_choice('savings::general.earned',1)); ?></th>
                                            <td>
                                                <?php echo e(number_format($savings->transactions->where('reversed',0)->where('savings_transaction_type_id',11)->sum('amount')+$savings->calculated_interest,$savings->decimals)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.interest',1)); ?> <?php echo e(trans_choice('savings::general.posted',1)); ?></th>
                                            <td>
                                                <?php echo e(number_format($savings->transactions->where('reversed',0)->where('savings_transaction_type_id',11)->sum('amount'),$savings->decimals)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="table-bold-savings"><?php echo e(trans_choice('core::general.total',1)); ?> <?php echo e(trans_choice('savings::general.deposit',2)); ?></th>
                                            <td>
                                                <?php echo e(number_format($savings->transactions->where('reversed',0)->where('savings_transaction_type_id',1)->sum('amount'),$savings->decimals)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="table-bold-savings"><?php echo e(trans_choice('core::general.total',1)); ?> <?php echo e(trans_choice('savings::general.withdrawal',2)); ?></th>
                                            <td>
                                                <?php echo e(number_format($savings->transactions->where('reversed',0)->where('savings_transaction_type_id',2)->sum('amount'),$savings->decimals)); ?>

                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                <?php endif; ?>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <table class="table table-striped table-bordered">
                                    <tbody>
                                    <tr>
                                        <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.status',1)); ?></th>
                                        <td>
                                            <?php if($savings->status=='submitted'): ?>
                                                <span class="label label-warning"><?php echo e(trans_choice('savings::general.pending_approval',1)); ?></span>
                                            <?php endif; ?>
                                            <?php if($savings->status=='approved'): ?>
                                                <span class="label label-warning"><?php echo e(trans_choice('savings::general.awaiting_activation',1)); ?></span>
                                            <?php endif; ?>
                                            <?php if($savings->status=='active'): ?>
                                                <span class="label label-success"><?php echo e(trans_choice('savings::general.active',1)); ?></span>
                                            <?php endif; ?>
                                            <?php if($savings->status=='withdrawn'): ?>
                                                <span class="label label-danger"><?php echo e(trans_choice('savings::general.withdrawn',1)); ?></span>
                                            <?php endif; ?>
                                            <?php if($savings->status=='rejected'): ?>
                                                <span class="label label-danger"><?php echo e(trans_choice('savings::general.rejected',1)); ?></span>
                                            <?php endif; ?>
                                            <?php if($savings->status=='closed'): ?>
                                                <span class="label label-info"><?php echo e(trans_choice('savings::general.closed',1)); ?></span>
                                            <?php endif; ?>
                                            <?php if($savings->status=='dormant'): ?>
                                                <span class="label label-warning"><?php echo e(trans_choice('savings::general.dormant',1)); ?></span>
                                            <?php endif; ?>
                                            <?php if($savings->status=='inactive'): ?>
                                                <span class="label label-warning"><?php echo e(trans_choice('savings::general.inactive',1)); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-savings"><?php echo e(trans_choice('client::general.client',1)); ?></th>
                                        <td>
                                            <?php if(!empty($savings->client)): ?>
                                                <a href="<?php echo e(url('client/'.$savings->client_id.'/show')); ?>"><?php echo e($savings->client->first_name); ?> <?php echo e($savings->client->middle_name); ?> <?php echo e($savings->client->last_name); ?></a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.account_number',1)); ?></th>
                                        <td>
                                            <?php echo e($savings->account_number); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.external_id',1)); ?></th>
                                        <td>
                                            <?php echo e($savings->external_id); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-savings"><?php echo e(trans_choice('core::general.currency',1)); ?></th>
                                        <td>
                                            <?php if(!empty($savings->currency)): ?>
                                                <?php echo e($savings->currency->name); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.savings',1)); ?> <?php echo e(trans_choice('savings::general.officer',1)); ?></th>
                                        <td>
                                            <?php if(!empty($savings->savings_officer)): ?>
                                                <?php echo e($savings->savings_officer->first_name); ?> <?php echo e($savings->savings_officer->last_name); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <tr>
                                        <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.interest_rate',1)); ?></th>
                                        <td>
                                            <?php echo e(number_format($savings->interest_rate,2)); ?>%
                                        </td>
                                    </tr>
                                    <?php if($savings->status=='active' ||$savings->status=='closed'||$savings->status=='dormant'||$savings->status=='inactive'): ?>
                                        <tr>
                                            <th class="table-bold-savings"><?php echo e(trans_choice('savings::general.activated_on',1)); ?></th>
                                            <td>
                                                <?php echo e($savings->activated_on_date); ?>

                                            </td>
                                        </tr>

                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row my-4">
            <div class="col-md-12">
                <div class="card card-primary card-outline card-outline-tabs">
                    <div class="card-header p-0 border-bottom-0">
                        <ul class="nav nav-tabs">
                            <li class="nav-item">
                                <a href="#account_details" class="nav-link active"
                                   data-toggle="tab">
                                    <?php echo e(trans_choice('savings::general.account',1)); ?> <?php echo e(trans_choice('core::general.detail',2)); ?>

                                </a>
                            </li>
                            <?php if($savings->status=='active' ||$savings->status=='closed'||$savings->status=='dormant'||$savings->status=='overpaid'||$savings->status=='rescheduled'): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.transactions.index')): ?>
                                    <li class="nav-item">
                                        <a href="#savings_transactions" class="nav-link"
                                           data-toggle="tab">
                                            <?php echo e(trans_choice('savings::general.transaction',2)); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.charges.index')): ?>
                                <li class="nav-item">
                                    <a href="#savings_charges" class="nav-link"
                                       data-toggle="tab">
                                        <?php echo e(trans_choice('savings::general.charge',2)); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account_details">
                                <table class="table table-striped table-hover">
                                    <tbody>
                                    <tr>
                                        <td><?php echo e(trans_choice('savings::general.compounding_period',1)); ?></td>
                                        <td>
                                            <?php if($savings->compounding_period=='daily'): ?>
                                                <?php echo e(trans_choice('savings::general.daily',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->compounding_period=='weekly'): ?>
                                                <?php echo e(trans_choice('savings::general.weekly',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->compounding_period=='monthly'): ?>
                                                <?php echo e(trans_choice('savings::general.monthly',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->compounding_period=='biannual'): ?>
                                                <?php echo e(trans_choice('savings::general.biannual',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->compounding_period=='annually'): ?>
                                                <?php echo e(trans_choice('savings::general.annually',2)); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(trans_choice('savings::general.interest_posting_period_type',1)); ?></td>
                                        <td>
                                            <?php if($savings->interest_posting_period_type=='daily'): ?>
                                                <?php echo e(trans_choice('savings::general.daily',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->interest_posting_period_type=='weekly'): ?>
                                                <?php echo e(trans_choice('savings::general.weekly',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->interest_posting_period_type=='monthly'): ?>
                                                <?php echo e(trans_choice('savings::general.monthly',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->interest_posting_period_type=='biannual'): ?>
                                                <?php echo e(trans_choice('savings::general.biannual',2)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->interest_posting_period_type=='annually'): ?>
                                                <?php echo e(trans_choice('savings::general.annually',2)); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(trans_choice('savings::general.interest_calculation_type',1)); ?></td>
                                        <td>
                                            <?php if($savings->interest_calculation_type=='daily_balance'): ?>
                                                <?php echo e(trans_choice('savings::general.daily_balance',1)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->interest_calculation_type=='average_daily_balance'): ?>
                                                <?php echo e(trans_choice('savings::general.average_balance',1)); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(trans_choice('savings::general.category',1)); ?></td>
                                        <td>
                                            <?php if($savings->savings_product->savings_category=='voluntary'): ?>
                                                <?php echo e(trans_choice('savings::general.voluntary',1)); ?>

                                            <?php endif; ?>
                                            <?php if($savings->savings_product->savings_category=='compulsory'): ?>
                                                <?php echo e(trans_choice('savings::general.compulsory',1)); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(trans_choice('core::general.submitted_on',1)); ?></td>
                                        <td>
                                            <?php echo e($savings->submitted_on_date); ?>

                                            <?php echo e(trans_choice('core::general.by',1)); ?>

                                            <?php if(!empty($savings->submitted_by)): ?>
                                                <?php echo e($savings->submitted_by->first_name); ?> <?php echo e($savings->submitted_by->last_name); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(trans_choice('savings::general.approved',1)); ?> <?php echo e(trans_choice('core::general.on',1)); ?></td>
                                        <td>
                                            <?php echo e($savings->approved_on_date); ?>


                                            <?php if(!empty($savings->approved_by)): ?>
                                                <?php echo e(trans_choice('core::general.by',1)); ?>

                                                <?php echo e($savings->approved_by->first_name); ?> <?php echo e($savings->approved_by->last_name); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(trans_choice('savings::general.activated',1)); ?> <?php echo e(trans_choice('core::general.on',1)); ?></td>
                                        <td>
                                            <?php echo e($savings->activated_on_date); ?>


                                            <?php if(!empty($savings->activated_by)): ?>
                                                <?php echo e(trans_choice('core::general.by',1)); ?>

                                                <?php echo e($savings->activated_by->first_name); ?> <?php echo e($savings->activated_by->last_name); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php $__currentLoopData = $custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom_field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        $field = custom_field_build_form_field($custom_field, $savings->id);
                                        ?>
                                        <tr>
                                            <td><?php echo e($field['label']); ?></td>
                                            <td>
                                                <?php if($custom_field->type=='checkbox'): ?>
                                                    <?php $__currentLoopData = explode(',',$field['current'] ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e($key); ?><br>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <?php echo e($field['current']); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php if($savings->status=='active' ||$savings->status=='closed'||$savings->status=='inactive'||$savings->status=='dormant'||$savings->status=='rescheduled'): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.transactions.index')): ?>
                                    <div class="tab-pane" id="savings_transactions">
                                        <table class="table table-striped table-hover"
                                               id="savings_transactions_table">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(trans_choice('core::general.date',1)); ?></th>
                                                <th><?php echo e(trans_choice('core::general.submitted_on',1)); ?></th>
                                                <th><?php echo e(trans_choice('savings::general.transaction',1)); ?> <?php echo e(trans_choice('core::general.type',1)); ?></th>
                                                <th><?php echo e(trans_choice('savings::general.transaction',1)); ?> <?php echo e(trans_choice('core::general.id',1)); ?></th>
                                                <th><?php echo e(trans_choice('accounting::general.debit',1)); ?></th>
                                                <th><?php echo e(trans_choice('accounting::general.credit',1)); ?></th>
                                                <th><?php echo e(trans_choice('savings::general.balance',1)); ?></th>
                                                <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $balance = 0;
                                            ?>
                                            <?php $__currentLoopData = $savings->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                $balance = $balance + $key->credit - $key->debit;
                                                ?>
                                                <tr>
                                                    <td><?php echo e($key->created_on); ?></td>
                                                    <td><?php echo e($key->submitted_on); ?></td>
                                                    <td>
                                                        <?php echo e($key->name); ?>

                                                    </td>
                                                    <td><?php echo e($key->id); ?></td>
                                                    <td><?php echo e(number_format($key->debit,$savings->decimals)); ?></td>
                                                    <td><?php echo e(number_format($key->credit,$savings->decimals)); ?></td>
                                                    <td><?php echo e(number_format($balance,$savings->decimals)); ?></td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <button href="#" class="btn btn-default dropdown-toggle"
                                                                    data-toggle="dropdown">
                                                                <i class="fas fa-ellipsis-h"></i>
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <a href="<?php echo e(url('savings/transaction/' . $key->id . '/show')); ?>"
                                                                   class="dropdown-item"><i
                                                                            class="fas fa-eye"></i> <?php echo e(trans_choice('core::general.view', 2)); ?>

                                                                </a>

                                                                <a href="<?php echo e(url('savings/transaction/' . $key->id . '/pdf')); ?>"
                                                                   target="_blank" class="dropdown-item"><i
                                                                            class="fas fa-file-pdf"></i> <?php echo e(trans_choice('core::general.receipt', 1)); ?>

                                                                </a>

                                                                <a href="<?php echo e(url('savings/transaction/' . $key->id . '/print')); ?>"
                                                                   target="_blank" class="dropdown-item"><i
                                                                            class="fa fa-print"></i> <?php echo e(trans_choice('core::general.print', 1)); ?>

                                                                </a>

                                                                <?php if($key->reversible == 1 && $key->reversed==0): ?>

                                                                    <a href="<?php echo e(url('savings/transaction/' . $key->id . '/edit')); ?>"
                                                                       class="dropdown-item"><i
                                                                                class="fas fa-edit"></i> <?php echo e(trans_choice('core::general.edit', 1)); ?>

                                                                    </a>
                                                                    <a href="<?php echo e(url('savings/transaction/' . $key->id . '/reverse')); ?>"
                                                                       class="dropdown-item confirm"><i
                                                                                class="fas fa-undo"></i> <?php echo e(trans_choice('savings::general.reverse', 1)); ?>

                                                                    </a>

                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.charges.index')): ?>
                                <div class="tab-pane" id="savings_charges">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.charges.create')): ?>
                                        <a href="<?php echo e(url('savings/'.$savings->id.'/charge/create')); ?>"
                                           class="btn btn-info float-right m-2"><?php echo e(trans_choice('core::general.add',1)); ?> <?php echo e(trans_choice('savings::general.charge',1)); ?></a>
                                    <?php endif; ?>
                                    <table class="table table-striped table-bordered table-hover">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('core::general.name',1)); ?></th>
                                            <th><?php echo e(trans_choice('savings::general.charge',1)); ?> <?php echo e(trans_choice('core::general.type',1)); ?></th>
                                            <th><?php echo e(trans_choice('savings::general.collected_on',1)); ?></th>
                                            <th><?php echo e(trans_choice('core::general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $savings->charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key->name); ?></td>
                                                <td>
                                                    <?php if($key->savings_charge_option_id==1): ?>
                                                        <?php echo e(number_format($key->amount,2)); ?> <?php echo e(trans_choice('savings::general.flat',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_option_id==2): ?>
                                                        <?php echo e(number_format($key->amount,2)); ?>

                                                        % <?php echo e(trans_choice('savings::general.percentage_of_amount',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_option_id==3): ?>
                                                        <?php echo e(number_format($key->amount,2)); ?>

                                                        %  <?php echo e(trans_choice('savings::general.percentage_of_savings_balance',1)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if($key->savings_charge_type_id==1): ?>
                                                        <?php echo e(trans_choice('savings::general.savings_activation',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_type_id==2): ?>
                                                        <?php echo e(trans_choice('savings::general.specified_due_date',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_type_id==3): ?>
                                                        <?php echo e(trans_choice('savings::general.withdrawal_fee',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_type_id==4): ?>
                                                        <?php echo e(trans_choice('savings::general.annual_fee',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_type_id==5): ?>
                                                        <?php echo e(trans_choice('savings::general.monthly_fee',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_type_id==6): ?>
                                                        <?php echo e(trans_choice('savings::general.inactivity_fee',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->savings_charge_type_id==7): ?>
                                                        <?php echo e(trans_choice('savings::general.quarterly_fee',1)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if($key->is_paid==1): ?>
                                                        <?php echo e(trans_choice('savings::general.charge',1)); ?> <?php echo e(trans_choice('savings::general.paid',1)); ?>

                                                    <?php else: ?>
                                                        <?php if($key->waived==1): ?>
                                                            <?php echo e(trans_choice('savings::general.charge',1)); ?> <?php echo e(trans_choice('savings::general.waived',1)); ?>

                                                        <?php else: ?>
                                                            <?php echo e(trans_choice('savings::general.outstanding',1)); ?>

                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('savings.savings.transactions.create')): ?>
                                                                <a href="<?php echo e(url('savings/charge/'.$key->id.'/pay')); ?>"
                                                                   class="btn btn-info btn-xs"><?php echo e(trans_choice('savings::general.pay',1)); ?></a>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                savings_officer_id: '<?php echo e(old('savings_officer_id',$savings->savings_officer_id)); ?>',
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Savings/Providers/../Resources/views/themes/adminlte/savings/show.blade.php ENDPATH**/ ?>