<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('core::general.payment',1)); ?> <?php echo e(trans_choice('core::general.gateway',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?php echo e(trans_choice('core::general.payment',1)); ?> <?php echo e(trans_choice('core::general.gateway',2)); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('core::general.payment',1)); ?> <?php echo e(trans_choice('core::general.gateway',2)); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="card card-bordered card-preview">
            <div class="card-body">
                <?php if(count($data)): ?>

                    <ul class="nav nav-tabs">
                        <?php $count = 1; ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a href="#<?php echo e($key->getName()); ?>"
                                   data-toggle="tab" class="nav-link <?php if($count==1): ?> active <?php endif; ?>">
                                    <?php echo e($key->getName()); ?>

                                </a>
                            </li>
                            <?php $count++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <div class="tab-content">
                        <?php $count = 1; ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $class = 'Modules\\' . $key->getName() . '\\' . $key->getName();
                            if (class_exists($class)) {
                                $gateway_class = new $class;
                            } else {
                                $gateway_class = '';
                            }
                            ?>
                            <div class="tab-pane <?php if($count==1): ?> active <?php endif; ?>" id="<?php echo e($key->getName()); ?>">
                                <?php if(!$gateway_class): ?>
                                    <div class="alert alert-danger"> <?php echo e(trans_choice('core::general.payment_gateway_is_broken',1)); ?></div>
                                <?php else: ?>
                                    <p><?php echo e($key->getDescription()); ?></p>
                                    <?php if(!empty($gateway_class->getLogo())): ?>
                                        <p><img src="<?php echo e($gateway_class->getLogo()); ?>" width="200"/></p>
                                    <?php endif; ?>
                                    <?php if($installed_gateway=$installed_payment_gateways->where('name',$key->getName())->first()): ?>
                                        <form method="post" action="<?php echo e(url('settings/payment_gateway/update')); ?>"
                                              class="form">
                                            <?php echo e(csrf_field()); ?>

                                            <input type="hidden" name="module" value="<?php echo e($key->getName()); ?>">
                                            <?php $__currentLoopData = $gateway_class->getSettings(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row gy-4">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <?php echo build_html_form_field((object)$setting); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <button type="submit"
                                                                class="btn btn-primary float-right"><?php echo e(trans_choice('general.save',1)); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="clearfix"></div>

                                        </form>
                                    <?php else: ?>
                                        <div class="alert alert-warning"> <?php echo e(trans_choice('core::general.payment_gateway_not_installed',1)); ?></div>
                                        <br>
                                        <a href="<?php echo e(url('settings/payment_gateway/install?module='.$key->getName())); ?>"
                                           class="btn btn-info confirm">
                                            <?php echo e(trans_choice('core::general.install',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <?php $count++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning"> <?php echo e(trans_choice('core::general.no_payment_gateway_found',1)); ?></div>
                <?php endif; ?>
            </div>

        </div><!-- .card-preview -->
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Core/Providers/../Resources/views/themes/adminlte/payment_gateway/index.blade.php ENDPATH**/ ?>