<?php $__env->startSection('title'); ?>
    <?php echo e(__('user::general.Activity Logs')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e(__('user::general.Activity Logs')); ?> / <strong
                                class="text-primary small"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></strong>
                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(__('user::general.Activity Logs')); ?> / <strong
                                    class="text-primary small"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></strong>
                        </li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="row">
            <div class="col-md-3">
                <?php echo $__env->make('user::themes.adminlte.user.profile.user_profile_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <!-- /.col -->
            <div class="col-md-9">
                <div class="card card-bordered card-preview">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e(__('user::general.Activity Logs')); ?></h4>
                    </div>
                    <div class="card-body">
                        <table class="table  table-striped table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(trans_choice('general.description',1)); ?></th>
                                <th><?php echo e(trans_choice('general.created_at',1)); ?></th>
                                <th><?php echo e(trans_choice('general.action',1)); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key->description); ?></td>
                                    <td><?php echo e($key->created_at->format('Y-m-d H:i:s')); ?></td>
                                    <td>
                                        <a href="<?php echo e(url('user/profile/activity_log/' . $key->id . '/show')); ?>"
                                           class="bg-white btn btn-sm btn-outline-light btn-icon btn-tooltip" title=""
                                           data-original-title="Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                    </div>
                    <div class="card-footer">
                        <?php echo e($data->links()); ?>

                    </div>
                </div>

            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/User/Providers/../Resources/views/themes/adminlte/user/profile/activity_log.blade.php ENDPATH**/ ?>