<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('loan::general.loan',1)); ?>  <?php echo e(trans_choice('loan::general.application',1)); ?> #<?php echo e($loan_application->id); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e(trans_choice('loan::general.loan',1)); ?>  <?php echo e(trans_choice('loan::general.application',1)); ?>

                        #<?php echo e($loan_application->id); ?>

                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('loan/application')); ?>"><?php echo e(trans_choice('loan::general.loan',1)); ?>  <?php echo e(trans_choice('loan::general.application',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('loan::general.loan',1)); ?>  <?php echo e(trans_choice('loan::general.application',1)); ?>

                            #<?php echo e($loan_application->id); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="card card-bordered card-preview">
            <div class="card-body">
                <table class="table  table-striped table-hover table-condensed" id="data-table">

                    <tr>
                        <td><?php echo e(trans_choice('core::general.id',1)); ?> </td>
                        <td><?php echo e($loan_application->id); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('core::general.branch',1)); ?> </td>
                        <td>
                            <?php if(!empty($loan_application->branch)): ?>
                                <?php echo e($loan_application->branch->name); ?>

                            <?php endif; ?>
                        </td>

                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('client::general.client',1)); ?> </td>
                        <td>
                            <?php if(!empty($loan_application->client)): ?>
                                <a href="<?php echo e(url('client/'.$loan_application->client_id.'/show')); ?>"><?php echo e($loan_application->client->first_name); ?> <?php echo e($loan_application->client->last_name); ?></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('loan::general.product',1)); ?> </td>
                        <td>
                            <?php if(!empty($loan_application->loan_product)): ?>
                                <?php echo e($loan_application->loan_product->name); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('loan::general.amount',1)); ?> </td>
                        <td><?php echo e(number_format($loan_application->amount,2)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('loan::general.status',1)); ?> </td>
                        <td>
                            <?php if($loan_application->status=='pending'): ?>
                                <?php echo e(trans_choice('loan::general.pending_approval',1)); ?>

                                <a href="<?php echo e(url('loan/application/'.$loan_application->id.'/approve')); ?>"
                                   class="btn btn-info"><?php echo e(trans_choice('loan::general.approve',1)); ?></a>
                                <a href="<?php echo e(url('loan/application/'.$loan_application->id.'/reject')); ?>"
                                   class="btn btn-danger confirm"><?php echo e(trans_choice('loan::general.reject',1)); ?></a>
                            <?php endif; ?>
                            <?php if($loan_application->status=='approved'): ?>
                                <?php echo e(trans_choice('loan::general.approved',1)); ?>

                            <?php endif; ?>
                            <?php if($loan_application->status=='rejected'): ?>
                                <?php echo e(trans_choice('loan::general.rejected',1)); ?>

                                <a href="<?php echo e(url('loan/application/'.$loan_application->id.'/undo_reject')); ?>"
                                   class="btn btn-danger confirm"><?php echo e(trans_choice('loan::general.undo',1)); ?> <?php echo e(trans_choice('loan::general.reject',1)); ?></a>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('core::general.date',1)); ?> </td>
                        <td><?php echo e($loan_application->created_at); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Loan/Providers/../Resources/views/themes/adminlte/application/show.blade.php ENDPATH**/ ?>