<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('dashboard::general.dashboard',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
    <style>
        .trash-item {
            position: absolute;
            bottom: 0;
            right: 20px;
            display: none;
        }

        .grid-stack-item-content:hover .trash-item {
            display: block;
            position: absolute;
            bottom: 0;
            right: 20px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item active"><a href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div id="app">
            <div class="row">
                <div class="col-md-12">
                    <button data-toggle="modal" data-target="#add_widget"
                            class="btn btn-info margin float-right">
                        <?php echo e(trans_choice('core::general.add',1)); ?>  <?php echo e(trans_choice('dashboard::general.widget',1)); ?>

                    </button>
                    <div class="modal fade" id="add_widget">
                        <div class="modal-dialog">
                            <form method="post" action="<?php echo e(url('dashboard/store_widget')); ?>"
                                  enctype="multipart/form-data">
                                <?php echo e(csrf_field()); ?>

                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title"><?php echo e(trans_choice('core::general.add',1)); ?>  <?php echo e(trans_choice('dashboard::general.widget',1)); ?></h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <label for="widget_id"
                                                   class="control-label"><?php echo e(trans_choice('dashboard::general.widget',1)); ?></label>
                                            <select class="form-control" name="widget_id" id="widget_id" required>
                                                <option value=""></option>
                                                <?php $__currentLoopData = $available_widgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value["name"]); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-default pull-left"
                                                data-dismiss="modal"><?php echo e(trans_choice('core::general.close',1)); ?> </button>
                                        <button type="submit"
                                                class="btn btn-primary"><?php echo e(trans_choice('core::general.save',1)); ?> </button>
                                    </div>
                                </div>
                            </form>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <!-- /.modal -->
                    <div class="grid-stack">
                        <?php $__currentLoopData = $user_widgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_widget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo app('arrilot.widget')->run($user_widget->class, ['x' =>
                            $user_widget->x,"y"=>$user_widget->y,"width"=>$user_widget->width,"height"=>$user_widget->height]); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/highcharts/6.0.6/highcharts.js" charset="utf-8"></script>
    <script>
        var grid = GridStack.init();
        grid.on('change', function (event, items) {
            let data = [];
            if (items) {
                items.forEach(function (item, index) {
                    data[index] = {
                        "id": item.id,
                        "x": item.x,
                        "y": item.y,
                        "width": item.w,
                        "height": item.h
                    };
                });
            }
            axios.post('<?php echo e(url('dashboard/update_widget_positions')); ?>', {
                widgets: data,
                _token: '<?php echo e(csrf_token()); ?>'
            }).then(function (response) {
                //toastr.success("<?php echo e(trans_choice("dashboard::general.successfully_rearranged", 1)); ?>");
            }).catch(function (error) {
                toastr.warning("<?php echo e(trans_choice("dashboard::general.failed_rearrange", 1)); ?>");
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Dashboard/Providers/../Resources/views/themes/adminlte/dashboard.blade.php ENDPATH**/ ?>