<div class="card card-primary card-outline">
    <div class="card-body box-profile">
        <div class="text-center">
            <?php if(!empty($user->photo)): ?>
                <a href="<?php echo e(asset('storage/uploads/'.$user->photo)); ?>"
                   class="fancybox">
                    <img
                            class="profile-user-img img-fluid img-circle"
                            src="<?php echo e(asset('storage/uploads/'.$user->photo)); ?>"
                            alt="User profile picture">
                </a>
            <?php else: ?>
                <img class="profile-user-img img-fluid img-circle"
                     src="<?php echo e(asset('themes/adminlte/img/user.png')); ?>"
                     alt="User profile picture">
            <?php endif; ?>
        </div>
        <h3 class="profile-username text-center">
            <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>

        </h3>
        <p class="text-muted text-center">
            <?php if($user->gender='male'): ?>
                <?php echo e(trans_choice("user::general.male",1)); ?>

            <?php elseif($user->gender='female'): ?>
                <?php echo e(trans_choice("user::general.female",1)); ?>

            <?php else: ?>
                <?php echo e(__('general.Unspecified')); ?>

                <?php echo e(trans_choice("user::general.unspecified",1)); ?>

            <?php endif; ?>
        </p>
        <p class="text-muted text-center">
            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="badge badge-light"><?php echo e($key->name); ?></span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </p>
        <p class="text-muted text-center">
            <a href="<?php echo e(url('user/'.$user->id.'/edit')); ?>"
               class="btn btn-info confirm  btn-sm mr-1"><?php echo e(trans_choice('core::general.edit',1)); ?></a>
            <a href="<?php echo e(url('user/'.$user->id.'/destroy')); ?>"
               class="btn btn-danger confirm btn-sm mr-1"><?php echo e(trans_choice('core::general.delete',1)); ?></a>
        </p>
        <div class="list-group list-group-unbordered mb-3">
            <a class="list-group-item <?php if(Request::segment(3)==''): ?> active <?php endif; ?>" href="<?php echo e(url('user/profile')); ?>">
                <i class="fas fa-user-edit"></i>
                <span><?php echo e(__('user::general.Account Information')); ?></span>
            </a>
            <a href="<?php echo e(url('user/profile/change_password')); ?>"
               class="list-group-item <?php if(Request::segment(3)=='change_password'): ?> active <?php endif; ?>">
                <em class="fas fa-user-shield"></em>
                <span> <?php echo e(__('user::general.Change Password')); ?></span>
            </a>
            <a href="<?php echo e(url('user/profile/notification')); ?>"
               class="list-group-item <?php if(Request::segment(3)=='notification'): ?> active <?php endif; ?>">
                <i class="fas fa-bell"></i>
                <span><?php echo e(__('user::general.Notifications')); ?></span>
            </a>
            <a href="<?php echo e(url('user/profile/activity_log')); ?>"
               class="list-group-item <?php if(Request::segment(3)=='activity_log'): ?> active <?php endif; ?>">
                <i class="fas fa-database"></i>
                <span><?php echo e(__('user::general.Activity Logs')); ?></span>
            </a>
            <a href="<?php echo e(url('user/profile/two_factor')); ?>"
               class="list-group-item <?php if(Request::segment(3)=='two_factor'): ?> active <?php endif; ?>">
                <i class="fas fa-lock"></i>
                <span><?php echo e(__('user::general.Two Factor Authentication')); ?></span>
            </a>
            <a href="<?php echo e(url('user/profile/note')); ?>"
               class="list-group-item <?php if(Request::segment(3)=='note'): ?> active <?php endif; ?>">
                <i class="fas fa-bookmark"></i>
                <span><?php echo e(__('user::general.Notes')); ?></span>
            </a>
            <a href="<?php echo e(url('user/profile/api')); ?>" class="list-group-item <?php if(Request::segment(3)=='api'): ?> active <?php endif; ?>">
                <i class="fas fa-code"></i>
                <span><?php echo e(__('user::general.API Keys')); ?></span>
            </a>
        </div>
    </div>
    <!-- /.card-body -->
</div>
<?php /**PATH /home/fistloan/public_html/CRM/Modules/User/Providers/../Resources/views/themes/adminlte/user/profile/user_profile_menu.blade.php ENDPATH**/ ?>