<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('core::general.manage',1)); ?> <?php echo e(trans_choice('core::general.menu',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>

    <style>
        body.dragging, body.dragging * {
            cursor: move !important;
        }

        .dragged {
            position: absolute;
            opacity: 0.5;
            z-index: 2000;
        }

        ul.sortable li.placeholder {
            position: relative;
            /** More li styles **/
        }

        ul.sortable li.placeholder:before {
            position: absolute;
            /** Define arrowhead **/
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <?php echo e(trans_choice('core::general.manage',1)); ?> <?php echo e(trans_choice('core::general.menu',2)); ?>

                        <a href="#" onclick="window.history.back()"
                           class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                            <em class="icon ni ni-arrow-left"></em><span><?php echo e(trans_choice('core::general.back',1)); ?></span>
                        </a>
                    </h1>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('core::general.manage',1)); ?> <?php echo e(trans_choice('core::general.menu',2)); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="card">
            <div class="card-header">
                <div class="btn-group">
                    <div class="dropdown">
                        <a href="#" class="btn btn-trigger btn-icon dropdown-toggle"
                           data-toggle="dropdown">
                            <i class="fas fa-wrench"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-xs">
                            <a class="dropdown-item"><span>Show</span></a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['per_page'=>10])); ?>"
                               class="dropdown-item <?php echo e(request('per_page')==10?'active':''); ?>">
                                10
                            </a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['per_page'=>20])); ?>"
                               class="dropdown-item <?php echo e((request('per_page')==20||!request('per_page'))?'active':''); ?>">
                                20
                            </a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['per_page'=>50])); ?>"
                               class="dropdown-item <?php echo e(request('per_page')==50?'active':''); ?>">50</a>
                            <a class="dropdown-item">Order</a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['order_by_dir'=>'asc'])); ?>"
                               class="dropdown-item <?php echo e((request('order_by_dir')=='asc'||!request('order_by_dir'))?'active':''); ?>">
                                ASC
                            </a>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['order_by_dir'=>'desc'])); ?>"
                               class="dropdown-item <?php echo e(request('order_by_dir')=='desc'?'active':''); ?>">
                                DESC
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-tools">
                    <button class="btn btn-info btn-sm" onclick="save_menu()">
                        <?php echo e(trans_choice('core::general.save',1)); ?>

                    </button>
                </div>
            </div>
            <div class="card-body table-responsive">
                <ul class="sortable list-group" id="space0">
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($parent->children->count()==0): ?>
                            <li class="list-group-item" data-id="<?php echo e($parent->id); ?>" data-name="<?php echo e($parent->name); ?>">
                                <i class="<?php echo e($parent->icon); ?>"></i> <span class="menu_title"><?php echo e($parent->name); ?></span>
                            </li>
                        <?php else: ?>
                            <li class="list-group-item" data-id="<?php echo e($parent->id); ?>" data-name="<?php echo e($parent->name); ?>">
                                <i class="<?php echo e($parent->icon); ?>"></i> <span class="menu_title"><?php echo e($parent->name); ?></span>
                                <ul class="list-group" style="margin-top: 10px">
                                    <?php $__currentLoopData = $parent->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item" data-id="<?php echo e($child->id); ?>"
                                            data-name="<?php echo e($child->name); ?>"><i
                                                    class="<?php echo e($child->icon); ?>"></i>
                                            <span class="menu_title"><?php echo e($child->name); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('plugins/jquery.editable/jquery.editable.min.js')); ?>"></script>
    <script>
        var group = $("ul.sortable").sortable({});

        function save_menu() {
            var data = group.sortable("serialize").get();

            var jsonString = JSON.stringify(data, null, ' ');
            axios.post('<?php echo e(url('menu/update')); ?>', {
                data: data,
                _token: "<?php echo e(csrf_token()); ?>"
            }).then(function (response) {
                swal({
                    text: response.data.msg,
                    type: 'success',
                    showCancelButton: false,
                    timer: 1500

                })
            }).catch(function (error) {

            });
            console.log(jsonString);
        }

        $("span.menu_title").editable({
            callback: function (data) {
                if (data.content) {
                    $(data.$el).closest('li').attr('data-name', data.content);
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/Core/Providers/../Resources/views/themes/adminlte/menu/index.blade.php ENDPATH**/ ?>