<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('user::general.performance_report',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?php echo e(trans_choice('user::general.performance_report',2)); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('dashboard')); ?>"><?php echo e(trans_choice('dashboard::general.dashboard',1)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('report')); ?>"><?php echo e(trans_choice('report::general.report',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                    href="<?php echo e(url('report/user')); ?>"><?php echo e(trans_choice('user::general.user',1)); ?> <?php echo e(trans_choice('report::general.report',2)); ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e(trans_choice('user::general.performance_report',2)); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content" id="app">
        <div class="card">
            <div class="card-header with-border">
                <h6 class="card-title">
                    <?php echo e(trans_choice('user::general.performance_report',2)); ?>

                    <?php if(!empty($start_date)): ?>
                        for period: <b><?php echo e($start_date); ?> to <?php echo e($end_date); ?></b>
                    <?php endif; ?>
                </h6>

                <div class="card-tools hidden-print">
                    <div class="dropdown">
                        <a href="#" class="btn btn-info btn-trigger btn-icon dropdown-toggle"
                           data-toggle="dropdown">
                            <?php echo e(trans_choice('core::general.action',2)); ?>

                        </a>
                        <div class="dropdown-menu dropdown-menu-xs dropdown-menu-right">
                            <a href="<?php echo e(url('report/user/performance?download=1&type=csv&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id.'&loan_officer_id='.$loan_officer_id)); ?>"
                               class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.csv_format',1)); ?></a>

                            <a href="<?php echo e(url('report/user/performance?download=1&type=excel&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id.'&loan_officer_id='.$loan_officer_id)); ?>"
                               class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.excel_format',1)); ?></a>

                            <a href="<?php echo e(url('report/user/performance?download=1&type=excel_2007&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id.'&loan_officer_id='.$loan_officer_id)); ?>"
                               class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.excel_2007_format',1)); ?></a>

                            <a href="<?php echo e(url('report/user/performance?download=1&type=pdf&start_date='.$start_date.'&end_date='.$end_date.'&branch_id='.$branch_id.'&loan_officer_id='.$loan_officer_id)); ?>"
                               class="dropdown-item"><?php echo e(trans_choice('core::general.download',1)); ?> <?php echo e(trans_choice('core::general.pdf_format',1)); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <form method="get" action="<?php echo e(Request::url()); ?>" class="">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"
                                       for="branch_id"><?php echo e(trans_choice('core::general.branch',1)); ?></label>
                                <select class="form-control select2" name="branch_id" id="branch_id">
                                    <option value="" disabled
                                            selected><?php echo e(trans_choice('core::general.select',1)); ?></option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key->id); ?>"
                                                <?php if($branch_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"
                                       for="start_date"><?php echo e(trans_choice('core::general.start_date',1)); ?></label>
                                <flat-pickr value="<?php echo e($start_date); ?>"
                                            class="form-control  <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="start_date" id="start_date" required>
                                </flat-pickr>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"
                                       for="end_date"><?php echo e(trans_choice('core::general.end_date',1)); ?></label>
                                <flat-pickr value="<?php echo e($end_date); ?>"
                                            class="form-control  <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="end_date" id="end_date" required>
                                </flat-pickr>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"
                                       for="loan_officer_id"><?php echo e(trans_choice('user::general.staff',1)); ?> </label>
                                <select class="form-control select2" name="loan_officer_id"
                                        id="loan_officer_id" required>
                                    <option value="" disabled
                                            selected><?php echo e(trans_choice('core::general.select',1)); ?></option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key->id); ?>"
                                                <?php if($loan_officer_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                        <span class="input-group-btn">
                          <button type="submit" class="btn bg-olive btn-flat"><?php echo e(trans_choice('core::general.filter',1)); ?>

                          </button>
                        </span>
                            <span class="input-group-btn">
                          <a href="<?php echo e(Request::url()); ?>"
                             class="btn bg-purple  btn-flat pull-right"><?php echo e(trans_choice('general.reset',1)); ?>!</a>
                        </span>
                        </div>
                    </div>
                </form>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.box -->
        <?php if(!empty($start_date)): ?>
            <div class="box box-white">
                <div class="box-body table-responsive no-padding">


                    <table class="table table-bordered table-condensed table-hover">
                        <thead>
                        <tr>
                            <th colspan="2">
                                <?php if( !empty($branch_id)): ?>
                                    <?php echo e(trans_choice('core::general.branch',1)); ?>:

                                    <?php echo e(\Modules\Branch\Entities\Branch::find($branch_id)->name); ?>

                                <?php endif; ?>
                            </th>
                        </tr>
                        <tr>
                            <th colspan="2">
                                <?php echo e(trans_choice('user::general.staff',1)); ?>:

                                <?php echo e(\Modules\User\Entities\User::find($loan_officer_id)->full_name); ?>

                            </th>
                        </tr>
                        <tr>
                            <th colspan="2"><?php echo e(trans_choice('core::general.start_date',1)); ?>: <?php echo e($start_date); ?></th>
                        </tr>
                        <tr>
                            <th colspan="2"><?php echo e(trans_choice('core::general.end_date',1)); ?>: <?php echo e($end_date); ?></th>
                        </tr>
                        <tr style="background-color: #D1F9FF">
                            <th colspan=""><?php echo e(trans_choice('user::general.item',1)); ?></th>
                            <th colspan=""><?php echo e(trans_choice('user::general.value',1)); ?></th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>
                                <?php echo e(__('user::general.Number of Clients')); ?>

                            </td>
                            <td><?php echo e(number_format($data['number_of_clients'])); ?></td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo e(__('user::general.Number of Loans')); ?>

                            </td>
                            <td><?php echo e(number_format($data['number_of_loans'])); ?></td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo e(__('user::general.Number of Savings')); ?>

                            </td>
                            <td><?php echo e(number_format($data['number_of_savings'])); ?></td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo e(__('user::general.Disbursed Loans Amount')); ?>

                            </td>
                            <td><?php echo e(number_format($data['disbursed_loans_amount'])); ?></td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo e(__('user::general.Total Payments Received')); ?>

                            </td>
                            <td><?php echo e(number_format($data['total_payments_received'])); ?></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        var app = new Vue({
            el: "#app",
            data: {},
            methods: {},
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fistloan/public_html/CRM/Modules/User/Providers/../Resources/views/themes/adminlte/report/performance.blade.php ENDPATH**/ ?>