<?php

/*

 * Template Name: Template Home 2

 * Description: A Page Template with a Page Builder design.

 */

/**

 * The header for our theme.

 *

 * This is the template that displays all of the <head> section and everything up until <div id="content">

 *

 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials

 *

 * @package borrow

 */



?><!DOCTYPE html>

<html <?php language_attributes(); ?>>

<?php global $borrow_option; ?>

<head>

	<meta charset="<?php bloginfo( 'charset' ); ?>">

	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="profile" href="http://gmpg.org/xfn/11">

	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">



    <!-- Favicons

    ================================================== -->

    <?php borrow_custom_favicon(); ?>



<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php get_template_part('framework/headers/header-2'); ?>



<?php if (have_posts()){ ?>

	

		<?php while (have_posts()) : the_post()?>

			<?php the_content(); ?>

		<?php endwhile; ?>

	

	<?php }else {

		esc_html_e('Page Canvas For Page Builder', 'borrow'); 

	}?>



<?php get_footer(); ?>