<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title> <?php echo $__env->yieldContent('title'); ?> </title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700">
    <link rel="stylesheet" href="<?php echo e(asset('themes/adminlte/css/adminlte.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('themes/adminlte/css/custom.css')); ?>" type="text/css"/>
    <?php echo $__env->yieldContent('styles'); ?>
    <script src="<?php echo e(asset('themes/adminlte/js/adminlte.js')); ?>"></script>
</head>
<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">
<div class="wrapper">
    <?php echo $__env->make('core::partials.top_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(Auth::user()->hasRole('client')): ?>
        <?php echo $__env->make('core::menu.client', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php else: ?>
        <?php echo $__env->make('core::menu.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <div class="content-wrapper">
        <section class="content pt-2">
            <div class="row">
                <div class="col-md-12">
                    <?php echo $__env->make('core::partials.flash.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </section>
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <?php echo $__env->make('core::partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<script src="<?php echo e(asset('themes/adminlte/js/custom.js')); ?>"></script>
<script>
    $(document).ready(function () {
        $('#flash-overlay-modal').modal();
        $('.confirm').on('click', function (e) {
            e.preventDefault();
            var href = $(this).attr('href');
            Swal.fire({
                title: '<?php echo e(trans_choice('core::general.are_you_sure',1)); ?>',
                text: '',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "<?php echo e(trans_choice('core::general.ok',1)); ?>",
                cancelButtonText: "<?php echo e(trans_choice('core::general.cancel',1)); ?>"
            }).then(function (result) {
                if (result.value) {
                    window.location = href;
                }

            })
        });

    })
</script>
<?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH /var/www/html/projects/loan.local/themes/adminlte/views/layouts/master.blade.php ENDPATH**/ ?>